#include <stddef.h>

#define MAXENV 20

int _child = 0;
char *_envtab[MAXENV] = { "COMSPEC=C:\\COMMAND.COM", 0L };
			/* default initial environment */
char *(*environ[]) = { _envtab };
int _env_inited = 0;

typedef struct
  {
    unsigned int  int_20_hex;
    unsigned int  top_of_memory;
    char          reserved1;
    char          dos_call[5];
    int           *term_address;
    int           *ctrl_brk_address;
    int           *crit_error_address;
    char          reserved2[22];
    unsigned int  environment;
  } program_segment_prefix;

extern program_segment_prefix *program_prefix;

void _initenv(void)
{
  char *envp;
  char **et;

  if ( _env_inited )
    return;
  _env_inited = 1;

  envp = (char *)(((long int)program_prefix->environment) << 16);
  et = _envtab;

  while ( *envp != 0 )
  {
    if ( et < &_envtab[MAXENV - 1] )
      *et++ = envp;
    else
    {
      /* printf("Too many environment variables\n"); */
      break;
    }
    while ( *envp++ != 0 );
  }
  *et = NULL;
}

char *getenv(varname)
  char *varname;
{
  char *envp, *v;
  char **et;

  if ( !_env_inited )
    _initenv();

  et = _envtab;
  while ( *et != NULL )
  {
    envp = *et++;
    v = varname;
    while ( (*envp != 0) && (*v == *envp) )
      {
	++v;
	++envp;
      }
    if ( (*envp == '=') && (*v == 0) )
      return envp + 1;
  }
  return NULL;
}
