-- w - write args to standard output.
--
-- This is a program similar to the PC-DOS ECHO command, with a
-- few bells and whistles thrown in.
--
-- usage: w [-s n] [-r n] [-n n] [text ...]
--
--   -s n = print n spaces before text
--   -r n = print n copies of text on same line
--   -n n = print n newlines before text
--            (at least one newline is always printed at the end)
--
-- original: 5 Apr 87, jns, Meridian Software Systems, Inc.

with arg;
with text_io;   use text_io;
procedure w is
  type string_p is access string;

  thisarg: string_p;
  argno: integer := 2;
  argpos: integer;
  space_count: integer := 0;
  rept_count: integer := 1;
  newline_count: integer := 0;
  printed_newline: Boolean := false;
  print_thisarg: Boolean := false;

  function next_arg return string_p is
    a: string_p;
  begin
    if argno <= arg.count then
      a := new string'(arg.data(argno));
      argno := argno + 1;
    else
      a := new string'("");
    end if;

    return a;
  end;

  function numarg return integer is
    thisarg: string_p;
    i: integer := 1;
    n: integer := 0;
  begin
    thisarg := next_arg;
    if thisarg'length = 0 then
      put_line("w: numeric argument expected");
    else
      while i <= thisarg'length and then thisarg(i) in '0'..'9' loop
	n := (n * 10) + (character'pos(thisarg(i)) - character'pos('0'));
	i := i + 1;
      end loop;
    end if;

    return n;
  end;

  procedure put_thisarg is
  begin
    while rept_count > 0 loop
      put(thisarg.all);
      rept_count := rept_count - 1;
    end loop;
    rept_count := 1;
    print_thisarg := false;
  end put_thisarg;

begin -- w
  while argno <= arg.count loop
    thisarg := next_arg;
    if thisarg'length > 0 then
      argpos := thisarg'first;
      if thisarg(argpos) = '-' then
	print_thisarg := false;
	argpos := argpos + 1;
	while argpos <= thisarg'length loop
	  case thisarg(argpos) is
	    when 's'    => space_count   := numarg;
	    when 'r'    => rept_count    := numarg;
	    when 'n'    => newline_count := numarg;
	    when others => print_thisarg := true;
	  end case;
	  argpos := argpos + 1;
	end loop;
      else
	print_thisarg := true;
      end if;

      while space_count > 0 loop
	put(' ');
	space_count := space_count - 1;
      end loop;
      if not print_thisarg then
	space_count := 0;
      else
	space_count := 1;
      end if;

      printed_newline := false;
      if newline_count > 0 then
	while newline_count > 0 loop
	  new_line;
	  newline_count := newline_count - 1;
	end loop;
	space_count := 0;
	printed_newline := true;
      end if;

      if print_thisarg then
	put_thisarg;
      end if;
    end if;
  end loop;

  if not printed_newline then
    new_line;
  end if;
end w;
