with text_io;  use text_io;
with bit_ops;
procedure botest is
begin
  put_line("TEST ""AND""");
  declare
    use bit_ops;
    r: integer;
  begin
    r := 0 and 0;       put_line("0 and 0 = <0>: " & integer'image(r));
    r := 0 and 1;       put_line("0 and 1 = <0>: " & integer'image(r));
    r := 1 and 0;       put_line("1 and 0 = <0>: " & integer'image(r));
    r := 1 and 1;       put_line("1 and 1 = <1>: " & integer'image(r));

    r := r and 16#7F#;  put_line("1 and 16#7F# = <1>: " & integer'image(r));
  end;

  put_line("TEST ""NOT""");
  declare
    use bit_ops;
    r: integer;
    rl: long_integer;
  begin
    r := not 0; put_line("not 0 = <-1>: " & integer'image(r));
    r := not 1; put_line("not 1 = <-2>: " & integer'image(r));

    rl := not 0; put_line("(long) not 0 = <-1>: " & long_integer'image(rl));
    rl := not 1; put_line("(long) not 1 = <-2>: " & long_integer'image(rl));
  end;

  put_line("TEST ""OR""");
  declare
    use bit_ops;
    r: integer;
  begin
    r := 0 or 0;       put_line("0 or 0 = <0>: " & integer'image(r));
    r := 0 or 1;       put_line("0 or 1 = <1>: " & integer'image(r));
    r := 1 or 0;       put_line("1 or 0 = <1>: " & integer'image(r));
    r := 1 or 1;       put_line("1 or 1 = <1>: " & integer'image(r));

    r := r or 16#7F#;  put_line("1 or 16#7F# = <127>: " & integer'image(r));
  end;


  put_line("TEST SHL");
  declare
    use bit_ops;
    r: integer;
    rl: long_integer;
  begin
    r := shl(integer'(1), 1);
	put_line("shl(integer'(1), 1) = <2>: " & integer'image(r));
    r := shl(integer'(1), integer'size - 2);
	put_line("shl(integer'(1), integer'size - 2) = <16_384>: "
		    & integer'image(r));
    r := shl(integer'(1), 0);
	put_line("shl(integer'(1), 0) = <1>: " & integer'image(r));

    rl := shl(long_integer'(1), 1);
	put_line("shl(long_integer'(1), 1) = <2>: " & long_integer'image(rl));
    rl := shl(long_integer'(1), long_integer'size - 2);
	put_line("shl(long_integer'(1), long_integer'size - 2) = "&
		    "<1_073_741_824>: " & long_integer'image(rl));
    rl := shl(long_integer'(1), 0);
	put_line("shl(long_integer'(1), 0) = <1>: " & long_integer'image(rl));
  end;

  put_line("TEST SHR");
  declare
    use bit_ops;
    r: integer;
    rl: long_integer;
  begin
    r := shr(integer'(1), 1);
	put_line("shr(integer'(1), 1) = <0>: " & integer'image(r));
    r := shr(integer'(16#4000#), integer'size - 2);
	put_line("shr(integer'(16#4000#), integer'size - 2) = <1>: " &
		   integer'image(r));
    r := shr(integer'(1), 0);
	put_line("shl(integer'(1), 0) = <1>: " & integer'image(r));

    rl := shr(long_integer'(1), 1);
	put_line("shr(long_integer'(1), 1) = <0>: " & long_integer'image(rl));
    rl := shr(long_integer'(16#4000_0000#), long_integer'size - 2);
	put_line("shr(long_integer'(16#4000_0000#), long_integer'size - 2) " &
		    "= <1>: " & long_integer'image(rl));
    rl := shr(long_integer'(1), 0);
	put_line("shr(long_integer'(1), 0) = <1>: " & long_integer'image(rl));
  end;

  put_line("TEST ""XOR""");
  declare
    use bit_ops;
    r: integer;
  begin
    r := 0 xor 0;       put_line("0 xor 0 = <0>: " & integer'image(r));
    r := 0 xor 1;       put_line("0 xor 1 = <1>: " & integer'image(r));
    r := r xor 16#A5#;  put_line("1 xor 16#A5# = <164>: " & integer'image(r));
    r := 1 xor 0;       put_line("1 xor 0 = <1>: " & integer'image(r));
    r := 1 xor 1;       put_line("1 xor 1 = <0>: " & integer'image(r));

    r := r xor 16#A5#;  put_line("0 xor 16#A5# = <165>: " & integer'image(r));
  end;


  put_line("---END TESTS---");
end botest;
