



--           Test program for Meridian Ada compiler.            --
-- This program computes a solution to the eight queens problem --
--     It is from "Ada: An Introduction" by Henry Ledgard.      --
--      Copyright (C) 1986 Meridian Software Systems, Inc.      --

with ada_io; use ada_io;
procedure queens is

min_row: constant integer := 1;
max_row: constant integer := 8;
min_col: constant integer := 1;
max_col: constant integer := 8;

min_up_diag: constant integer := min_row + min_col;
max_up_diag: constant integer := max_row + max_col;
min_down_diag: constant integer := min_row - max_col;
max_down_diag: constant integer := max_row - min_col;

field_width: constant integer := 3;

safe_row:       array(min_row..max_row)             of boolean;
safe_up_diag:   array(min_up_diag..max_up_diag)     of boolean;
safe_down_diag: array(min_down_diag..max_down_diag) of boolean;
configuration:  array(min_col..max_col)             of integer;

row: integer;
col: integer;

procedure clear_the_board is
begin
  safe_row       := (min_row..max_row => true);
  safe_up_diag   := (min_up_diag..max_up_diag => true);
  safe_down_diag := (min_down_diag..max_down_diag => true);
end;

procedure set_queen(row, col: in integer) is
begin
  safe_row(row)           := false;
  safe_up_diag(row+col)   := false;
  safe_down_diag(row-col) := false;
  configuration(col)      := row;
end;

procedure remove_queen(row, col: in integer) is
  vacant: constant integer := 0;
begin
  safe_row(row)           := true;
  safe_up_diag(row+col)   := true;
  safe_down_diag(row-col) := true;
  configuration(col)      := vacant;
end;

function is_safe(row, col: in integer) return boolean is
begin
  if safe_row(row) and safe_up_diag(row+col)
  and safe_down_diag(row-col) then
    return true;
  else
    return false;
  end if;
end;

procedure print_the_board is
  square: string(1..field_width) := (others => ' ');
begin
  for i in min_col..max_col loop
    for j in min_row..max_row loop
      if j = configuration(i) then
	square(1) := 'X';
      else
	square(1) := '.';
      end if;
      put(square);
    end loop;
    new_line;
  end loop;
end;

begin -- main program
  row := 1;
  col := 1;
  clear_the_board;
  put("PROGRAM TO SOLVE THE EIGHT QUEENS PROBLEM");
  new_line;
  while (col <= max_col) loop
    while (row <= max_row) and (col <= max_col) loop
      if is_safe(row, col) then
	set_queen(row, col);
	col := col+1;
	row := 1;
      else
	row := row+1;
      end if;
    end loop;

    if (row = max_row + 1) then
      col := col-1;
      row := configuration(col);
      remove_queen(row, col);
      row := row+1;
    end if;
  end loop;
  print_the_board;
end;
