;**********************************************************************
; ADOSTST - Small test of Ada/Assembly PRAGMA INTERFACE
;
;   Note: That these are all FAR routines and that all pointers
;         to data are passed as FAR (or DWORD) pointers.
;         The data segment name must be DATA, but the code segment
;         name can be any name that does not conflict with other
;         object modules.
;**********************************************************************

	NAME    ADOSTST

	DGROUP  GROUP   DATA

DATA    SEGMENT PUBLIC  'DATA'  ; Global data segment
DATA    ENDS

_ADOSTST   SEGMENT PUBLIC  'CODE'  ; Code segment for this module

	ASSUME  CS:_ADOSTST, DS:DGROUP


;**********************************************************************
; Procedure dos_standard_output(ch: character);
;**********************************************************************

	PUBLIC  DOS_OUTPUT_CHAR

DOS_OUTPUT_CHAR   PROC    FAR
	PUSH    BP
	MOV     BP, SP
	MOV     DL, [BP+6]      ; ch
	MOV     AH, 02H         ; Function: Display Output
	INT     21H             ; DOS call
	POP     BP
	RET     2               ; Pop ch argument off
DOS_OUTPUT_CHAR   ENDP


;***********************************************************************
; Procedure dos_output_str(str: in string);
;
;  str is passed as an array descriptor which looks like this:
;
;  type arrdesc =
;    record
;      ptr: system.address;     -- pointer to string data
;      first: integer;          -- str'first
;      last:  integer;          -- str'last
;    end;
;***********************************************************************

	PUBLIC  DOS_OUTPUT_STR

DOS_OUTPUT_STR    PROC    FAR
	PUSH    BP
	MOV     BP, SP
	PUSH    DS              ; Save DS
	LDS     SI, DWORD PTR [BP+6]    ; str
	LDS     DX, DWORD PTR SS:[SI]   ; str.ptr
	MOV     AH, 09H         ; Function: Print String
	INT     21H             ; DOS call
	POP     DS
	POP     BP
	RET     4               ; Pop far pointer argument off
DOS_OUTPUT_STR    ENDP


;***********************************************************************
; Function dos_input_ready return boolean;
;***********************************************************************

	PUBLIC  DOS_INPUT_READY

DOS_INPUT_READY   PROC    FAR
	PUSH    BP
	MOV     BP, SP
	MOV     AH, 0BH         ; Function: Check Standard Input Status
	INT     21H             ; DOS call
	SUB     CX, CX
	ADD     CL, AL          ; Return results in CX and convert value
	JZ      SKIP            ;  of 0FFH to 1 for a proper boolean
	MOV     CX, 1
SKIP:   POP     BP
	RET
DOS_INPUT_READY   ENDP


;***********************************************************************
; type dos_time is
;   record
;     centisecs: byte_integer;  -- 0 .. 99
;     seconds:   byte_integer;  -- 0 .. 59
;     minutes:   byte_integer;  -- 0 .. 59
;     hours:     byte_integer;  -- 0 .. 23
;   end;
;
; Procedure dos_get_time(timeval: out dos_time);
;***********************************************************************

	PUBLIC  DOS_GET_TIME

DOS_GET_TIME    PROC    FAR
	PUSH    BP
	MOV     BP, SP
	MOV     AH, 2CH         ; Function: Get time
	INT     21H             ; DOS call
	PUSH    ES              ; Save ES
	LES     SI, DWORD PTR [BP+6]  ; timeval
	MOV     ES:[SI], DX     ; seconds:centiseconds
	MOV     ES:[SI+2], CX   ; hours:minutes
	POP     ES
	POP     BP
	RET     4               ; Pop far pointer argument off
DOS_GET_TIME    ENDP


;***********************************************************************
; dos_version() word /* AL = major version, AH = minor version */
;                    /* DOS 3.1 = 0103H */
; Procedure dos_version(major_version: out byte_integer;
;                       minor_version: out byte_integer);
;***********************************************************************

	PUBLIC  DOS_VERSION

DOS_VERSION     PROC    FAR
	PUSH    BP
	MOV     BP, SP
	MOV     AH, 30H         ; Function: Get DOS Version Number
	INT     21H             ; DOS call
				; AL = major version, AH = minor version
	PUSH    ES              ; Save ES
	LES     SI, DWORD PTR [BP+6]  ; major_version
	MOV     ES:[SI], AL
	LES     SI, DWORD PTR [BP+10] ; minor_version
	MOV     ES:[SI], AH
	POP     ES
	POP     BP
	RET     8               ; Pop 2 far pointer arguments off
DOS_VERSION     ENDP


_ADOSTST   ENDS                 ; End of code segment

	END                     ; End of module ADOSTST
