/*
=============================================================================

	Filename:		awmcisam.h

    Description:    General header for Animation MCI Sample Program.

=============================================================================
*/

#ifndef AWMCISAM_H				// Done so this include file won't...
#define AWMCISAM_H				// ...be included twice

#include <stdlib.h>
#include <stdio.h>
#undef  NULL
#include <windows.h>
#include <mmsystem.h>

#ifdef RC_INVOKED
#define ID(id)	id
#else
#define ID(id)	MAKEINTRESOURCE(id)
#endif

// Program Version Number
#define msMCISAMVERSION RGB (2, 0, 0)

#define msMAX  128

int PASCAL WinMain(HANDLE, HANDLE, LPSTR, int);
LONG FAR PASCAL MainWndProc(HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL msMainDlgProc (HWND, unsigned, WORD ,LONG);
BOOL FAR PASCAL msOpenDlgProc (HWND, unsigned, WORD ,LONG);
BOOL FAR PASCAL msSeekDlgProc (HWND, unsigned, WORD ,LONG);
BOOL FAR PASCAL msDevCapsDlgProc (HWND, unsigned, WORD ,LONG);
BOOL FAR PASCAL msInfoDlgProc (HWND, unsigned, WORD ,LONG);
BOOL FAR PASCAL msStatusDlgProc (HWND, unsigned, WORD ,LONG);
BOOL FAR PASCAL msAboutDlgProc (HWND, unsigned, WORD ,LONG);


//
//  Dialog Box IDs
//

#define IDDLG_MAIN      ID(7000)
#define IDDLG_OPEN      ID(7001)
#define IDDLG_SEEK      ID(7002)
#define IDDLG_DEVCAPS   ID(7003)
#define IDDLG_INFO      ID(7004)
#define IDDLG_STATUS    ID(7005)
#define IDDLG_ABOUT     ID(7006)


//
//  General Definitions
//

// ID for the 'OK' and 'Cancel' push buttons of all dialog boxes
#define IDPB_OK				1
#define IDPB_CANCEL			2


//
//  Dialog Box Definitions
//

//  'Main' Dialog Box

#define IDPB_MAIN_STOP              100
#define IDPB_MAIN_PAUSE             101
#define IDPB_MAIN_PLAY_FORWARD      102
#define IDPB_MAIN_PLAY_REVERSE      103
#define IDPB_MAIN_STEP_FORWARD      104
#define IDPB_MAIN_STEP_REVERSE      105
#define IDPB_MAIN_OPEN              106
#define IDPB_MAIN_CLOSE             107
#define IDPB_MAIN_SEEK              108
#define IDPB_MAIN_DEV_CAP           109
#define IDPB_MAIN_STATUS            110
#define IDPB_MAIN_INFO              111
#define IDCB_MAIN_BKGND_LOAD        112
#define IDCB_MAIN_FULL_SCRN			113
#define IDPB_MAIN_TOSTART           114
#define IDPB_MAIN_TOEND             115

// 'Open' Dialog Box

#define IDEB_OPEN_MOVIE_FILE        200

// 'Seek' Dialog Box

#define IDEB_SEEK_TOFRAME           300

// 'Device Capabilities' Dialog Box

#define IDST_DEVCAP_EJECT           400
#define IDST_DEVCAP_PLAY            401
#define IDST_DEVCAP_RECORD          402
#define IDST_DEVCAP_SAVE            403
#define IDST_DEVCAP_DEVELE          404
#define IDST_DEVCAP_DEVTYPE         405
#define IDST_DEVCAP_AUDIO           406
#define IDST_DEVCAP_VIDEO           407
#define IDST_DEVCAP_USESFILES       408
#define IDST_DEVCAP_PLAYREVERSE     409
#define IDST_DEVCAP_STRETCH         410
#define IDST_DEVCAP_FASTRATE        411
#define IDST_DEVCAP_PALETTE         412
#define IDST_DEVCAP_SLOWRATE        413
#define IDST_DEVCAP_MAXWIN          414
#define IDST_DEVCAP_NORMRATE        415
#define IDST_MAIN_PLAYWND           416

// 'Info' Dialog Box

#define IDST_INFO_FILENAME          500
#define IDST_INFO_CAPTION           501
#define IDST_INFO_PRODUCT           502
#define IDST_INFO_DDVERSION         503

// 'Status' Dialog Box

#define IDST_STATUS_CURRFRAME       600
#define IDST_STATUS_NUMFRAMES       601
#define IDST_STATUS_CURRMODE        602
#define IDST_STATUS_SPEED           603
#define IDST_STATUS_HWND            604

// 'About' Dialog Box

#define IDST_VERSION                700


//
//  Strings Definitions
//

#define IDS_ERROR_TITLE             1000
#define IDS_DEVTYPE_ANIMATION       1001
#define IDS_DEVTYPE_CD_AUDIO        1002
#define IDS_DEVTYPE_DAT             1003
#define IDS_DEVTYPE_DIGITAL_VIDEO   1004
#define IDS_DEVTYPE_OTHER           1005
#define IDS_DEVTYPE_OVERLAY         1006
#define IDS_DEVTYPE_SCANNER         1007
#define IDS_DEVTYPE_SEQUENCER       1008
#define IDS_DEVTYPE_VIDEODISC       1009
#define IDS_DEVTYPE_VIDEOTAPE       1010
#define IDS_DEVTYPE_WAVEFORM_AUDIO  1011

#define IDS_UNKNOWN                 1012
#define IDS_UNSUPPORTED_FUNCTION    1013
#define IDS_SUPPORTED_FUNCTION      1014

#define IDS_MODE_NOT_READY          1015
#define IDS_MODE_PAUSE              1016
#define IDS_MODE_PLAY_FORWARD       1017
#define IDS_MODE_PLAY_REVERSE       1018
#define IDS_MODE_STOP               1019
#define IDS_MODE_OPEN               1020
#define IDS_MODE_RECORD             1021
#define IDS_MODE_SEEK               1022

#define IDS_ABOUT                   1023


//
//  Menus Definitions
//

#define IDM_ABOUT                   2000


//
//  Icon Definitions
//

#define IDI_APPICON 		        ID(3000)


#endif	/* ifndef AWMCISAM_H */
