#ifndef PNTTOOLS_H
#define PNTTOOLS_H
//========================================================================================
//
//     File:			PntTools.h
//     Creation Date:	4/14/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRMOUSEA_H
#include <BRMouseA.h>
#endif

class BR_CPen;
class BR_CPoint;
struct cDrawState;

//========================================================================================
//	class cPaintTool
//========================================================================================

class cPaintTool : public BR_CMouseAction
{
public:
						cPaintTool(cDrawState *State, int BitmapResourceId, int CursorResId);		
	virtual				~cPaintTool();

	int					GetBitmapId();
	int					GetCursorId();
	
	// Overridden methods
	virtual void		BeginTracking(const BR_CPoint &p);
	virtual void		EndTracking(const BR_CPoint &p);

protected:
	BR_CDrawInitiator	*fInitiator;	// Default draw initiator
	cDrawState			*fDrawState;	// Cuurent state information for drawing
	int					fBitmapResId;	// Id for bitmap that appears in the tool palette
	int					fCursorId;		// Id for cursor when this tool is chosen
};

#endif
