//========================================================================================
//
//     File:			PaintApp.cp
//     Creation Date:	4/13/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRAPPLIC_H
#include <BRApplic.h>
#endif

#ifndef BRCHORE_H
#include <BRChore.h>
#endif

#ifndef BRDOCWIN_H
#include <BRDocWin.h>
#endif

#ifndef BRDOCUME_H
#include <BRDocume.h>
#endif

#ifndef BREDITCO_H
#include <BREditCo.h>
#endif

#ifndef BRDLGDIR_H
#include <BRDlgDir.h>
#endif

#ifndef BRFILEFI_H
#include <BRFileFi.h>
#endif

#ifndef BRMDIDES_H
#include <BRMDIDes.h>
#endif

#ifndef BRMENU_H
#include <BRMenu.h>
#endif

#ifndef BRMNUBAR_H
#include <BRMnuBar.h>
#endif

#ifndef BROPENFD_H
#include <BROpenFD.h>
#endif

#ifndef BRSTATUS_H
#include <BRStatus.h>
#endif

#ifndef PAINT_H
#include "Paint.h"
#endif

#ifndef PAINTAPP_H
#include "PaintApp.h"
#endif

#ifndef PAINTDOC_H
#include "PaintDoc.h"
#endif

#ifndef PNTSTABR_H
#include "PntStaBr.h"
#endif

#ifndef LINEGRID_H
#include "LineGrid.h"
#endif

#ifndef COLORWIN_H
#include "ColorWin.h"
#endif

#ifndef TOOLWIND_H
#include "ToolWind.h"
#endif

#ifndef PNTTOOLS_H
#include "PntTools.h"
#endif

#ifndef DRWSTATE_H
#include "DrwState.h"
#endif

DEFINE_CLASS(cPaintApp, BR_CApplication);

//----------------------------------------------------------------------------------------
// cPaintApp::cPaintApp
//----------------------------------------------------------------------------------------

cPaintApp::cPaintApp(BR_CSystem* System) :
	BR_CApplication(System, this, IDS_APPNAME)
{
	fDrawState = new cDrawState;
}

//----------------------------------------------------------------------------------------
// cPaintApp::~cPaintApp
//----------------------------------------------------------------------------------------

cPaintApp::~cPaintApp()
{
	delete fDrawState;
}

//----------------------------------------------------------------------------------------
// cPaintApp::CreateDocument
//
// Creates a new document.
//----------------------------------------------------------------------------------------

BR_CDocument* cPaintApp::CreateDocument()
{
	cPaintDoc *document = new cPaintDoc(this, fDrawState);
   	document->NewWindow();
   	document->NewFile();
	return document;
}

//----------------------------------------------------------------------------------------
// cPaintApp::OpenDocument
//
// Opens an existing document.
//----------------------------------------------------------------------------------------

BR_CDocument* cPaintApp::OpenDocument(BR_CFileSpecification &fileSpec)
{
	cPaintDoc *pDocument = new cPaintDoc(this, fDrawState);
   	pDocument->NewWindow();
	if( !pDocument->OpenFile(fileSpec) )
	{
		delete pDocument;
	}
	pDocument->GetWindow(0)->Show();
	return pDocument;
}

//----------------------------------------------------------------------------------------
// cPaintApp::SetUpFileParameters
//
// Add BMP files to the FileFilter List.
//----------------------------------------------------------------------------------------

void cPaintApp::SetUpFileParameters()
{
	BR_CApplication::SetUpFileParameters();
#ifdef BR_BUILD_WIN	
	//
	//	Set up file filter list.
	//
	BR_CSFPDialogInfo *pSFDialogInfo = GetSFPDialogInfo();
	if (&List != NULL)
	{
		BR_CFileFilter *BMPFilter = new BR_CFileFilter("Bitmap Files (*.BMP;*.DIB)");
		BMPFilter->AddPattern("*.BMP");
		BMPFilter->AddPattern("*.DIB");
		pSFDialogInfo->WinAddFileFilter(0, *BMPFilter);
	}
#endif
}

//----------------------------------------------------------------------------------------
// cPaintApp::MakeAppDesktop
//
// Makes the Application Desktop. Creates the cMyStatusBar, cToolWindow, and cColorWindow.
//----------------------------------------------------------------------------------------

BR_CAppDesktop* cPaintApp::MakeAppDesktop()
{
	BR_CAppDesktop * appDesktop = BR_CApplication::MakeAppDesktop();

	cToolWindow * ToolWindow;
	cColorWindow * ColorWindow;
	ToolWindow = new cToolWindow(appDesktop, appDesktop, fDrawState);

	// Create a new color pallette on the App Desktop
	ColorWindow = new cColorWindow(appDesktop, appDesktop, fDrawState);

#ifdef BR_BUILD_WIN
	// Create a new status bar at the bottom of the desktop.
	// This status bar contains sub-views to display help status
	// and other information.
	fStatusBar = new cMyStatusBar(appDesktop, 1000, 25, 0, 3, BEDSZ_FITENCLOSURE);
#endif

	return appDesktop;
}

//----------------------------------------------------------------------------------------
// cPaintApp::UpdateMenus
//
// Called when the menus are activated.
//----------------------------------------------------------------------------------------

void cPaintApp::UpdateMenus(BR_CMenuBar& menuBar, BR_Boolean fCallSupervisor)
{
	BR_CApplication::UpdateMenus(menuBar, fCallSupervisor);

	menuBar.EnableCmd(cmdAboutBox);
}

//----------------------------------------------------------------------------------------
// cPaintApp::DoCommand
//
// Handles menu commands.
//----------------------------------------------------------------------------------------

BR_Boolean cPaintApp::DoCommand(unsigned short cmdId,
								BR_CObject* notifier,
								BR_Boolean fCallSupervisor)
{
	BR_Boolean hCommandHandled = TRUE;

	switch (cmdId)
	{
		case cmdAboutBox:
			DoAboutBox();
			break;
		default:
			hCommandHandled = BR_CApplication::DoCommand(cmdId, notifier, fCallSupervisor);
	}
	return hCommandHandled;
}

//----------------------------------------------------------------------------------------
// cPaintApp::ShowHelpStatusString
//
// Shows the help status string in the application's status bar.
//----------------------------------------------------------------------------------------

BR_Boolean cPaintApp::ShowHelpStatusString(const BR_TString<BR_Char> &helpStatusString)
{
#ifdef BR_BUILD_WIN
	fStatusBar->GetHelpRect().SetText((BR_TString_BR_Char_ &) helpStatusString);
#endif	
	return TRUE;
}

//----------------------------------------------------------------------------------------
// cPaintApp::DoAboutBox
//
// Creates an about box for the program.
//----------------------------------------------------------------------------------------

void cPaintApp::DoAboutBox()
{
	BR_CDialogDirector aboutBoxDialog((BR_CBureaucrat *)this, (BR_CView *)this, *GetApplication(), IDD_ABOUTBOX_DIALOG);
	aboutBoxDialog.ShowDialog();
}
