#ifndef DRWSTATE_H
#define DRWSTATE_H
//========================================================================================
//
//     File:			DrwState.h
//     Creation Date:	4/13/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

class cPaintTool;
class BR_CBitmap;
class BR_CColor;

//========================================================================================
// struct cDrawState
//
// This class holds information about the current drawing environment like current tool,
// bitmap, color, linewidth, and whether we are currently drawing.
//========================================================================================

struct cDrawState
{
public:
					cDrawState();

	cPaintTool		*fCurrentTool;		// Pointer to current tool
	BR_CBitmap		*fCurrentBitmap;	// Pointer to current bitmap

	BR_CColor		fCurrentColor;		// Current color
	int				fCurrentLineWidth;	// Current line width
	BR_Boolean		fIsDrawing;			// Flag that specifies if drawing
};


//----------------------------------------------------------------------------------------
// cDrawState::cDrawState
//----------------------------------------------------------------------------------------

inline cDrawState::cDrawState() :
	fCurrentTool(NULL),
	fCurrentBitmap(NULL),
	fCurrentLineWidth(3),
	fIsDrawing(FALSE)
{
}

#endif




