#ifndef BNDTOOLS_H
#define BNDTOOLS_H
//========================================================================================
//
//     File:			BndTools.h
//     Creation Date:	4/13/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef PNTTOOLS_H
#include "PntTools.h"
#endif

class BR_CPen;
class BR_CPoint;
struct cDrawState;


//========================================================================================
// class cRubberBandTool
//
// The cRubberBandTool class sets up a framework for creating tools easily by setting up
// the drawing environment and then makes calls to DrawObject to draw whatever object is
// being drawn.
//========================================================================================

class cRubberBandTool : public cPaintTool
{
public:
	cRubberBandTool(cDrawState *State, BR_Boolean FillFlag, 
					int BitmapResourceId, int CursorResId);
	virtual ~cRubberBandTool();

	virtual void BeginTracking(const BR_CPoint &p);	//Override
	virtual void KeepTracking(const BR_CPoint &p);	//Override
	virtual void EndTracking(const BR_CPoint &p);		//Override
	
	//	Override this method to draw different types of objects.
	virtual	void DrawObject() = 0;
	
protected:
	BR_DrawMode		fOldDrawMode;	// Save the old draw mode while drawing
	BR_Boolean		fFilled;			// Determines if a Drawobject is filled
	BR_CPoint			fStartPoint;	// First point of drawing
	BR_CPoint			fEndPoint;		// Point to draw to.

	BR_CPen				*fPen;				// Pen that is used to draw the rubber band...
	BR_CWallPaper	*fWallPaper;	// Back ground wallpaper 
};


//========================================================================================
//	class cSquareTool
//========================================================================================

class cSquareTool : public cRubberBandTool
{
public:
	cSquareTool(cDrawState *State, int Filled, int BitmapResourceId);
	virtual ~cSquareTool();
	
	void DrawObject(); // Draw the square
};


//========================================================================================
//	class cLineTool
//========================================================================================

class cLineTool : public cRubberBandTool
{
public:
	cLineTool(cDrawState *State, int BitmapResourceId);
	virtual ~cLineTool();
	
	void DrawObject();	//	Draw the line
};


//========================================================================================
//	class cEllipseTool
//========================================================================================

class cEllipseTool : public cRubberBandTool
{
public:
	cEllipseTool(cDrawState *State, int Filled, int BitmapResourceId);
	virtual ~cEllipseTool();
	
	void DrawObject();	// Draw the Ellipse
};


//========================================================================================
//	class cRoundRectangleTool
//========================================================================================

class cRoundRectangleTool: public cRubberBandTool
{
public:
	cRoundRectangleTool(cDrawState *State, int Filled, int BitmapResourceId);
	virtual ~cRoundRectangleTool();
	
	void DrawObject();	// Draw the Round Rectangle
	
private:
	enum  { RectangleRoundness = 30 };
};
#endif