//========================================================================================
//
//     File:			myDrwDoc.cp
//     Release Version:	$Revision$
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   MYDRWDOC_H
#include "myDrwDoc.h"
#endif

#ifndef   MYDRAW_K
#include "myDraw.k"
#endif

#ifndef   MYDRWDLG_H
#include "myDrwDlg.h"
#endif

#ifndef   MYDRWOBJ_H
#include "myDrwObj.h"
#endif

#ifndef   MYDRWVW_H
#include "myDrwVw.h"
#endif

#ifndef   BRCOLLEC_H
#include <BRCollec.h>
#endif

#ifndef   BRDEBUG_H
#include <BRDebug.h>
#endif

#ifndef   BRMENU_H
#include <BRMenu.h>
#endif

#ifndef   BRORCOLL_H
#include <BROrColl.h>
#endif

#ifndef   BRPEN_H
#include <BRPen.h>
#endif

#ifndef   BRSTRING_H
#include <BRString.h>
#endif

#ifndef   BRWINDOW_H
#include <BRWindow.h>
#endif

//========================================================================================
// CLASS CMyDrawDocument
//========================================================================================

//----------------------------------------------------------------------------------------
// CMyDrawDocument::CMyDrawDocument
//----------------------------------------------------------------------------------------

CMyDrawDocument::CMyDrawDocument(BR_CApplication* application)
  : BR_CDocument(application, FALSE /*printable*/), fPen(1, kRGBBlack, kSolidPen)
{
	fWindow			= NULL;
	fMainView		= NULL;
	fToolCommand	= cmdSelect;
}

//----------------------------------------------------------------------------------------
// CMyDrawDocument::~CMyDrawDocument
//----------------------------------------------------------------------------------------

CMyDrawDocument::~CMyDrawDocument(void)
{
}

//----------------------------------------------------------------------------------------
// CMyDrawDocument::AddDrawObject
//----------------------------------------------------------------------------------------

void CMyDrawDocument::AddDrawObject(CMyDrawObject* object)
{
    fObjectList.Add(object);
}

//----------------------------------------------------------------------------------------
// CMyDrawDocument::DeselectAllObjects
//----------------------------------------------------------------------------------------

void CMyDrawDocument::DeselectAllObjects()
{
	BR_CDrawInitiator di(fMainView);
	
	DO(fObjectList, CMyDrawObject, dObject)
		dObject->SetSelectAndDraw(FALSE, fMainView);
	ENDDO
}

//----------------------------------------------------------------------------------------
// CMyDrawDocument::DoCommand
//----------------------------------------------------------------------------------------

BR_Boolean CMyDrawDocument::DoCommand(BR_CBureaucrat::CommandId theId,
	BR_CObject* notifier, BR_Boolean callSupervisor)
{	
	switch (theId)
	{
		case cmdPenSize1:
			SetPenThickness(1);
			break;
		
		case cmdPenSize2:
			SetPenThickness(2);
			break;

		case cmdPenSize3:
			SetPenThickness(3);
			break;
			
		case cmdPenSetup:
			RunPenSetupDialog();
			break;

		case cmdSelect:
		case cmdLine:
		case cmdRect:
		case cmdEllipse:
		case cmdRRect:
			DeselectAllObjects();
			fToolCommand = theId;
			break;
			
		case cmdSelectAll:
			SelectAllObjects();
			break;

		default:
			return (BR_CDocument::DoCommand(theId, notifier, callSupervisor));
	}
	return (TRUE);
}

//----------------------------------------------------------------------------------------
// CMyDrawDocument::GetUnitString
//----------------------------------------------------------------------------------------

void CMyDrawDocument::GetUnitString(BR_CStr32& theStr)
{
	unsigned short index;
	switch (fWindow->GetUnits())
	{
		case kPixelUnits:		// also point units on the Mac
			index = 1;
			break;

		case kLoMetricUnits:	// .1 mm
			index = 2;
			break;

		case kHiMetricUnits:	// .01 mm
			index = 3;
			break;

		case kLoEnglishUnits:	// .01 in
			index = 4;
			break;

		case kHiEnglishUnits:	// .001 in
			index = 5;
			break;

		case kTwipsUnits:		// 1/20 point (1/1440 in)
			index = 6;
			break;

#ifdef BR_BUILD_WIN
 		case kPointUnits:		// 1 point
			index = 7;
			break;
#endif

		default:
			index = 8;
	}

	theStr.LoadResource(*(BR_CModule*)GetSupervisor(), UNIT_STRINGS, index);

	return;
}

//----------------------------------------------------------------------------------------
// CMyDrawDocument::NewWindow
//----------------------------------------------------------------------------------------

void CMyDrawDocument::NewWindow()
{
    BR_CApplication* app	= (BR_CApplication*)GetSupervisor();
	BR_CAppDesktop*	 desk	= app->GetAppDesktop();

    fWindow					= LoadWindow(desk, app, app, ID_MYDRAW_WINDOW);
	fMainView				= (CMyDrawView*)fWindow->GetSubviewId(ID_MYDRAW_VIEW);
	Assert(fMainView);

    fWindow->Show();
}

//----------------------------------------------------------------------------------------
// CMyDrawDocument::RemoveDrawObject
//----------------------------------------------------------------------------------------

void CMyDrawDocument::RemoveDrawObject(CMyDrawObject* object)
{
	fObjectList.Remove((BR_CObject&)(*object));
}

//----------------------------------------------------------------------------------------
// CMyDrawDocument::RunPenSetupDialog
//----------------------------------------------------------------------------------------

void CMyDrawDocument::RunPenSetupDialog()
{
	BR_CApplication* app	= GetApplication();
	BR_CAppDesktop*  desk	= app->GetAppDesktop();
	CPenSetupDialog penDialogDirector(this, desk, *app, fPen.GetThickness());	

	penDialogDirector.ShowDialog();
}

//----------------------------------------------------------------------------------------
// CMyDrawDocument::SelectAllObjects
//----------------------------------------------------------------------------------------

void CMyDrawDocument::SelectAllObjects()
{
	BR_CDrawInitiator di(fMainView);

	DO(fObjectList, CMyDrawObject, dObject)
		dObject->SetSelectAndDraw(TRUE, fMainView);
	ENDDO
}

//----------------------------------------------------------------------------------------
// CMyDrawDocument::SetPenThickness
//----------------------------------------------------------------------------------------

void CMyDrawDocument::SetPenThickness(BR_CPen::PenThickness newThickness)
{	
	fPen.SetThickness(newThickness);
}

//----------------------------------------------------------------------------------------
// CMyDrawDocument::UpdateMenus
//----------------------------------------------------------------------------------------

void CMyDrawDocument::UpdateMenus(BR_CMenuBar& menuBar,
						 	BR_Boolean callSupervisor)
{
	BR_CDocument::UpdateMenus(menuBar, callSupervisor);

	menuBar.EnableCmd(cmdPenSize1);
	menuBar.EnableCmd(cmdPenSize2);
	menuBar.EnableCmd(cmdPenSize3);
	menuBar.EnableCmd(cmdPenSetup);
	
	BR_CStr32 cmdTxt;
	menuBar.GetCmdText(cmdPenSize1, cmdTxt, FALSE); 
	
	if (cmdTxt.GetLength() <= 1) {

		BR_CStr32 units;
		GetUnitString(units);
	
		cmdTxt += units;
		menuBar.SetCmdText(cmdPenSize1, cmdTxt);
	
		menuBar.GetCmdText(cmdPenSize2, cmdTxt, FALSE);  
		cmdTxt += units;
		menuBar.SetCmdText(cmdPenSize2, cmdTxt);
	
		menuBar.GetCmdText(cmdPenSize3, cmdTxt, FALSE);  
		cmdTxt += units;
		menuBar.SetCmdText(cmdPenSize3, cmdTxt);
	}
	
	switch (fPen.GetThickness())
	{
		case 1:
			menuBar.CheckCmd(cmdPenSize1);
			break;

		case 2:
			menuBar.CheckCmd(cmdPenSize2);
			break;
	
		case 3:
			menuBar.CheckCmd(cmdPenSize3);
			break;
			
		default:
			menuBar.CheckCmd(cmdPenSetup);
			break;
	}
	
	menuBar.EnableCmd(cmdSelect);
	menuBar.EnableCmd(cmdLine);
	menuBar.EnableCmd(cmdRect);
	menuBar.EnableCmd(cmdEllipse);
	menuBar.EnableCmd(cmdRRect);

	menuBar.CheckCmd(fToolCommand);

	menuBar.EnableCmd(cmdSelectAll, fObjectList.Size() > 0);
}

