//========================================================================================
//
//     File:			myDrwBun.r
//     Release Version:	$Revision$
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef __TYPES.R__
#include "Types.r"
#endif

#ifndef __SYSTYPES.R__
#include "SysTypes.r"
#endif

// Include custom Icons
include "myDrawIcons.rsrc" not 'ckid';

//--------------------------------------------------------------------------------------------------
// Constants 
//--------------------------------------------------------------------------------------------------

// Finder Information
// ------------------

#define kApplicationName				$$Shell("XAppName")
#define kSignature						'myDr'				// Application signature 
#define kFileType						'myDR'				// Data file type 
#define kStationery						'smDR'				// Stationery file type 

// Bundle Constants
// ------------------

#define kBundleID						128
#define kApplicationID					128
#define kDocumentID						129
#define kStationeryID					130

//--------------------------------------------------------------------------------------------------
// Icons, Bundles and FRefsOh my! (don't forget the Signature)
//--------------------------------------------------------------------------------------------------

type kSignature as 'STR ';
resource kSignature (0,
#if qNames
"Signature",
#endif
	purgeable) {
	"myDraw 1992-1993 Apple Computer, Inc., SYMANTEC, Inc."
};

resource 'FREF' (kApplicationID,
#if qNames
"myDraw Application",
#endif
	purgeable) {
	'APPL',
	0,
	""
};

resource 'FREF' (kDocumentID,
#if qNames
"myDraw Document",
#endif
	purgeable) {
	kFileType,
	1,
	""
};

resource 'FREF' (kStationeryID,
#if qNames
"myDraw Stationery",
#endif
	purgeable) {
	kStationery,
	2,
	""
};

resource 'BNDL' (kBundleID,
#if qNames
"myDraw",
#endif
	purgeable) {
	kSignature,
	0,
	{ /* array TypeArray: 2 elements */
		/* [1] */
		'ICN#',
		{ /* array IDArray: 3 elements */
			0, kApplicationID,
			1, kDocumentID,
			2, kStationeryID
		},
		/* [2] */
		'FREF',
		{ /* array IDArray: 3 elements */
			0, kApplicationID,
			1, kDocumentID,
			2, kStationeryID
		}
	}
};

//--------------------------------------------------------------------------------------------------
//  Version resources
//--------------------------------------------------------------------------------------------------

// The revision of this particular file

resource 'vers' (1,
#if qNames
"File Version",
#endif
	purgeable) {
	0x01,
	0x00,
	alpha,
	0x04,
	verUs,
	"1.0a4",
	"1.0a4, 1992-1993 Apple Computer, Inc., SYMANTEC, Inc."
};

resource 'vers' (2,
#if qNames
	"Package Version",
#endif
	purgeable) {
	0x01,
	0x00,
	release,
	0x00,
	verUs,
	"Bedrock 1.0",
	"Bedrock 1.0"
};
