#ifndef EDDOC_H
#define EDDOC_H
//===================================================================================
//
//     File:			EdDoc.h
//     Release Version:	$Revision$
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT
//     NOTICE IS PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions
//     as set forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and
//     Computer Software clause at DFARS 252.227-7013.
//     Symantec Corporation, 10201 Torre Avenue, Cupertino, CA 95014.
//
//===================================================================================

#ifndef EDEDTEXT_H
#include "EdEdText.h"
#endif

#ifndef BRDOCUME_H
#include <BRDocume.h>
#endif

//-----------------------------------------------------------------------------------
// class cEditDoc
//
// The editor Document.
//-----------------------------------------------------------------------------------

class cEditDoc : public BR_CDocument
{
public:
						cEditDoc(BR_CApplication *application);
	virtual        		~cEditDoc();

	// Overridden virtual methods
	virtual void		NewWindow();
	virtual BR_Boolean	DoSave();
	virtual BR_Boolean	DoSaveAs(const BR_CFileSpecification &fileSpec);
	virtual void		DoRevert();
	virtual void		UpdateMenus(BR_CMenuBar &aMenuBar, BR_Boolean fCallSupervisor);
	virtual BR_Boolean	DoCommand(unsigned short cmdId, 
								  BR_CObject *notifier,
								  BR_Boolean fCallSupervisor);

private:
	cEdEditText			*fEdEditText;		// Pointer to the document's cEdEditText
	BR_CTextStream		*fTextStream;		// Pointer to the document's cTextStream

						BR_SETCLASSNAME(cEditDoc);
};

#endif
