//===================================================================================
//
//     File:			Ed3DAdrn.cp
//     Release Version:	$Revision$
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT
//     NOTICE IS PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions
//     as set forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and
//     Computer Software clause at DFARS 252.227-7013.
//     Symantec Corporation, 10201 Torre Avenue, Cupertino, CA 95014.
//
//===================================================================================

#ifndef ED3DADRN_H
#include "Ed3DAdrn.h"
#endif

#ifndef BRVIEW_H
#include <BRView.h>
#endif

#ifndef BRCANVAS_H
#include <BRCanvas.h>
#endif

DEFINE_CLASS(cThreeDAdorner, BR_CShapeAdorner)

//-----------------------------------------------------------------------------------
// cThreeDAdorner::cThreeDAdorner
//
// This class creates a 3-D adornment for the status bar rectangles.
//-----------------------------------------------------------------------------------

cThreeDAdorner::cThreeDAdorner(AdornerId adornerID) :
	BR_CShapeAdorner(adornerID, TRUE, TRUE, 5, kRGBBlack, kSolidPen, kRGBTransparent)
{
}


//-----------------------------------------------------------------------------------
// cThreeDAdorner::cThreeDAdorner
//
// This class creates a 3-D adornment for the status bar rectangles.
//-----------------------------------------------------------------------------------

cThreeDAdorner::~cThreeDAdorner()
{
}

//-----------------------------------------------------------------------------------
// cThreeDAdorner::Draw
//
// This class creates a 3-D adornment for the status bar rectangles.
//-----------------------------------------------------------------------------------

void cThreeDAdorner::Draw(BR_CView *view, const BR_CRectangle &bounds)
{
	BR_CPen			*whitePen = new BR_CPen(kRGBWhite);
	BR_CPen			*blackPen = new BR_CPen(kRGBDarkGray);
	BR_CCanvas		*canvas = view->GetCanvas();
	
	// Draw a 3-D border around the rectangle
	BR_CGraphicsToolSelector(view, blackPen);

	canvas->MovePenTo(bounds.fLeft, bounds.fTop);
	canvas->DrawLineTo(bounds.fRight, bounds.fTop);
	canvas->MovePenTo(bounds.fLeft, bounds.fTop);
	canvas->DrawLineTo(bounds.fLeft, bounds.fBottom);

	BR_CGraphicsToolSelector(view, whitePen);

	canvas->MovePenTo(bounds.fRight, bounds.fBottom);
	canvas->DrawLineTo(bounds.fRight, bounds.fTop);
	canvas->MovePenTo(bounds.fRight, bounds.fBottom);
	canvas->DrawLineTo(bounds.fLeft, bounds.fBottom);
}