#ifndef BRPRIMEM_H
#define BRPRIMEM_H
//========================================================================================
//
//	File:				BRPriMem.h
//	Release Version:	$ 1.0d1 $
//
//	Creation Date:		12/8/92
//
//	COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//	RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//	PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
// 	THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
// 	CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//	EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//	RESTRICTED RIGHTS LEGEND
//	Use, duplication, or disclosure by the Government is subject to restrictions as Set
//	forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//	Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//	Cupertino, CA 95014.
//
//========================================================================================

#include <stddef.h>

//----------------------------------------------------------------------------------------
// Primitive Memory Operations
//
//	These functions provide a platform-independent interface to low level operating
//	system services for memory management.  The functions impose minimal requirements
//	on the underlying environment, and are built in the simplest way on top of native
//	operating system APIs.
//
//	Memory blocks allocated and freed by these functions can be as large as can be
//	requested with a size_t parameter, but these routines should generally not be
//	used for large allocations.
//
//	This function are intended for use by very low-level code.  Applications (and most
//	of Bedrock) should use higher level interfaces.
//
//----------------------------------------------------------------------------------------

void *BR_PrimitiveAllocateBlock(size_t bytesRequested);
	// Returns 0 if request could not be satisfied.
	
void *BR_PrimitiveResizeBlock(void *block, size_t bytesRequested);
	// The block may be moved to satisfy request.
	// Returns 0 if request could not be satisfied.
	// Resize of NULL or invalid block is undefined (platform-dependent).
	
void  BR_PrimitiveFreeBlock(void *block);
	// Free of invalid block is undefined (platform-dependent).
	// It is a no-op to try to free NULL.

size_t BR_PrimitiveGetBlockSize(void* p);
	// Returns size in bytes.
	// Size of NULL or invalid block is undefined (platform-dependent).

void BR_PrimitiveCopyMemory(const void *source, void *destination, size_t bytes);
	// No error detection provided
	
#endif