/*========================================================================================
  / 
  /      File:		BRSyFile.h
  /      Release Version:	$ 1.0d1 $
  / 
  /      Creation Date:	November 5, 1989
  / 
  /      COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
  /      RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
  /      PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
  / 
  /      THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
  /      CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
  /      EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
  / 
  /      RESTRICTED RIGHTS LEGEND
  /      Use, duplication, or disclosure by the Government is subject to restrictions as Set
  /      forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
  /      Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
  /      Cupertino, CA 95014.
  / 
  /=======================================================================================*/


/*--------------------------------------------------------------------------------------
//	This file is part of the old international implementation.
//	The Bedrock team is in the process of designing a totally new approach.
//	For more details on the new approach please look in the 
//	":BEDROCK:INTL:INCLUDES:" folder.
//	The new approach departs from the close tie to characters and characterSets.
//	Instead it bases all internationalization efforts on locale based
//	characters, and character sets, with Unicode as the central set.
/--------------------------------------------------------------------------------------*/



#ifndef BRSYFILE_H
#define BRSYFILE_H

#ifndef BRSUPDEF_H
#include "BRSupDef.h"
#endif

#ifndef BRTIME_H
#include "BRTime.h"
#endif

#ifndef BRSTR_H
#include "BRStr.h"
#endif

#ifdef __cplusplus
extern "C"
{
#endif

#define BR_FILE_DRIVESEPARATOR		':'
#define BR_FILE_PATHSEPARATOR 		'\\'
#define BR_FILE_ISDRIVESEPARATOR(ch)	((ch) == ':')
#define BR_FILE_ISPATHSEPARATOR(ch)	((ch) == '/' || (ch) == '\\')


	/* Attributes --- */
	/*Type Attribute*/

	/*Used for the creation or search for files*/

typedef unsigned short BR_FileSystemAttribute;

#define BR_FileSysAttr_kReadWrite     (0x0000)
#define BR_FileSysAttr_kNormal		(0x0000)
#define BR_FileSysAttr_kReadOnly		(0x0001)
#define BR_FileSysAttr_kHidden		(0x0002)
#define BR_FileSysAttr_kSystem		(0x0004)
#define BR_FileSysAttr_kDirectories   (0x0010)
#define BR_FileSysAttr_kArchive	    (0x0020)
#define BR_FileSysAttr_kDrives	    (0x4000)
#define BR_FileSysAttr_kExclusive     (0x8000)
#define BR_FileSysAttr_kDrivesAndDirectories     (BR_FileSysAttr_kDirectories|BR_FileSysAttr_kDrives|BR_FileSysAttr_kExclusive)
#define BR_FileSysAttr_kStationary     (0x0008)
#define BR_FileSysAttr_kAlias     	(0x0040)


	/*Action*/

	/*Use to specify action on Open command, Open and Create mean to first BR_TRY*/
	/*to Open the file as is, if this fails because the file does not exist then*/
	/*go ahead and Create the file*/

typedef unsigned short BR_FileOpenAction;

#define BR_FileOpenAction_kCreate		OF_CREATE
#define BR_FileOpenAction_kOpen		(0x0004)
#define BR_FileOpenAction_kTruncate		(0x0008)
#define BR_FileOpenAction_kCreateTruncate	(BR_FileOpenAction_kCreate | BR_FileOpenAction_kOpen | BR_FileOpenAction_kTruncate)

	/*Access*/
	/*Specifies the mode of operation the current application wishes to exercise*/
	/*on this file, and what rights it wishes to give other applications while*/
	/*this application has the file Open*/

typedef unsigned short BR_FileAccessMode;
#define BR_FileAccessMode_kReadOnly		OF_READ
#define BR_FileAccessMode_kReadWrite		OF_READWRITE
#define BR_FileAccessMode_kWriteOnly		OF_WRITE

typedef unsigned short BR_FileSharingMode;
#define BR_FileShareMode_kDenyNone			OF_SHARE_DENY_NONE
#define BR_FileShareMode_kDenyRead			OF_SHARE_DENY_READ
#define BR_FileShareMode_kDenyWrite		OF_SHARE_DENY_WRITE
#define BR_FileShareMode_kDenyReadWrite	OF_SHARE_EXCLUSIVE

#define BR_FileShareMode_kCompatible	    OF_SHARE_COMPAT
#define BR_FileShareMode_kExclusive	    OF_SHARE_EXCLUSIVE


	/*Misc*/

typedef unsigned short BR_FileSystemUsageMode;

#define BR_FileSysUsageMode_kReadVerify	(0x0001)
#define BR_FileSysUsageMode_kReturnAllErrors	(0x0002)
#define BR_FileSysUsageMode_kWriteThrough	(0x0004)


	/*Seek Commands*/

typedef enum
{
	BR_FilePosMode_kFromStart = 0, BR_FilePosMode_kFromEndOfFile = 2, BR_FilePosMode_kFromCurrent = 1
} BR_FilePositionMode;

	/*Copy Command*/

typedef enum
{
	BR_FileSysCopyMode_kNoExisting,						/* Don't Copy if target exists */
	BR_FileSysCopyMode_kExisting,							/* Copy even if target exists */
	BR_FileSysCopyMode_kAppend							/* Append to target */
} BR_FileSystemCopyMode;


	/*File System Error Codes -- ***Partial List*** */

#define BR_DOS_MAXFILEROOTLEN 9
#define BR_DOS_MAXFILENAME 13

typedef enum
{
	BR_FileSysErr_kNoError,
	BR_FileSysErr_kFileDoesNotExist,
	BR_FileSysErr_kAccessDenied,
	BR_FileSysErr_kDiskFull,
	BR_FileSysErr_kInvalidHandle,
	BR_FileSysErr_kFileLockViolation, 
	BR_FileSysErr_kCanNotCreate,
	BR_FileSysErr_kDriveLocked,
	BR_FileSysErr_kInvalidAccess, 
	BR_FileSysErr_kInvalidParameter,
	BR_FileSysErr_kPathNotFound, 
	BR_FileSysErr_kShareBufferExceeded, 
	BR_FileSysErr_kShareViolation,
	BR_FileSysErr_kTooManyFilesOpen,
	BR_FileSysErr_kDataError,
	BR_FileSysErr_kInvalidDriveSpecification,
	BR_FileSysErr_kInvalidFileNameRoot,
	BR_FileSysErr_kUnknown
} BR_FileSystemError, FAR* BR_FileSystemErrorPtr;


#define  BR_FileTokenType_kDriveSeparator	1
#define  BR_FileTokenType_kNetworkSpecification 	2
#define  BR_FileTokenType_kPathSeparator 	3
#define  BR_FileTokenType_kExtensionSeparator		4

typedef unsigned long BR_FileMeasurmentUnit;


/*========================================================================================
/	struct BR_SFileInfo
/
/	<comments>
/	<Invariants>
/========================================================================================*/
typedef struct BR_SFileInfo
{
	BR_SDateTime fFileCreationDateTime;
	BR_SDateTime fFileModificationDateTime;
	BR_SDateTime fFileAccessDateTime;
	BR_VMHandle fFileName;
	BR_FileMeasurmentUnit fFileSize;
	BR_FileMeasurmentUnit fFileAllocation;
	BR_FileSystemAttribute fFileAttribute;
	BR_FileAccessMode fFileAccess;
	BR_FileSharingMode fFileShare;
	BR_FileSystemUsageMode fFileUsage;
	BR_VMHandle fFileType;
	BR_VMHandle fFileCreator;
	/* the fNext 3 items are specific to WINDOWS */
	BR_FileSystemError fLastError;
	BR_Boolean fIsTemporaryFile;
	BR_PlatformHandle fSystemHandle;
} BR_SFileInfo, FAR * BR_SFileInfoPtr;


	/*
	  Open must return an fError code within the procedure since it otherwise
	  would not return a handle which is needed for BR_FileError.	This differs
	  from the BR_DOS style environment since we are multi-tasking, we must always
	  associated an fError with its own particular file.
	*/

BR_EXPORTENTRY(BR_FileSystemError) BR_Open (
	BR_FileHandle FAR* filehandle,
	BR_BedString filename,
	BR_FileSystemAttribute fFileAttribute,
	BR_FileOpenAction openAction,
	BR_FileAccessMode accessMode,
	BR_FileSharingMode shareMode,
	BR_FileSystemUsageMode fFileUsage,
	BR_FileMeasurmentUnit filesize);
	
	
BR_EXPORTENTRY (BR_FileSystemError) BR_Close (BR_FileHandle hf);

BR_EXPORTENTRY (BR_FileSystemError) BR_Flush(BR_FileHandle hf);

BR_EXPORTENTRY (BR_FileSystemError) BR_FileError(BR_FileHandle hf);

BR_EXPORTENTRY (BR_FileSystemError) BR_QueryFileInfo(BR_FileHandle hf, BR_SFileInfoPtr fInfo);

BR_EXPORTENTRY (BR_FileSystemError) BR_SetFileInfo(BR_FileHandle hf, BR_SFileInfoPtr fInfo);

BR_EXPORTENTRY (void) BR_QueryPathSepChar (BR_BedString s, unsigned short maxlen);


BR_EXPORTENTRY (BR_FileSystemError) BR_GetAppInfo (
	BR_BedString groupStr, 
	BR_BedString itemStr, 
	BR_BedString info, 
	BS_StringLength maxInfoLen);

BR_EXPORTENTRY (BR_FileSystemError) BR_SetAppInfo(
	BR_BedString groupStr, 
	BR_BedString itemStr, 
	BR_BedString data);


BR_EXPORTENTRY (BR_FileSystemError) BR_GetSystemFileHandle (BR_FileHandle hf, HFILE FAR * sysf);

BR_EXPORTENTRY (BR_FileSystemError) BR_GetTemporaryFile (
	BR_FileHandle FAR * hf, 
	BR_FileAccessMode accessMode, 
	BR_FileSharingMode shareMode, 
	BR_FileSystemUsageMode fFileUsage, 
	BR_FileMeasurmentUnit minSizeNeeded);


BR_EXPORTENTRY (BR_FileSystemError) BR_FileRangeLock(
	BR_FileHandle hf, 
	BR_FileMeasurmentUnit Offset, 
	BR_FileMeasurmentUnit range);

BR_EXPORTENTRY (BR_FileSystemError) BR_FileRangeUnLock(
	BR_FileHandle hf, 
	BR_FileMeasurmentUnit Offset, 
	BR_FileMeasurmentUnit range);


BR_EXPORTENTRY (BR_FileSystemError) BR_CopyFile (
	BR_BedString filename1, 
	BR_BedString filename2, 
	BR_FileSystemCopyMode mode);

BR_EXPORTENTRY (BR_FileSystemError) BR_Delete(BR_BedString filename);

BR_EXPORTENTRY (BR_FileSystemError) BR_Rename(BR_BedString filename1, BR_BedString filename2);

BR_EXPORTENTRY (BR_FileSystemError) BR_MoveFile(BR_BedString filename1, BR_BedString filename2);

BR_EXPORTENTRY (BR_Boolean) BR_IsPath (BR_StringPtr name, BS_StringLength cnt);

/*
BR_EXPORTENTRY (BR_FileSystemError) BR_ParseFileName (
	BR_StringPtr nameToParse, 
	BS_StringLength nameLen, 
	BR_StringPtr drive, 
	unsigned short FAR * maxDriveLen, 
	BR_StringPtr path, 
	unsigned short FAR * maxPathLen, 
	BR_StringPtr file, 
	unsigned short FAR * maxFileLen, 
	BR_StringPtr fileRoot, 
	unsigned short FAR * maxFileRootLen, 
	BR_StringPtr fileExt, 
	unsigned short FAR * maxFileExtLen, 
	short FAR * driveID, 
	long FAR * dirID);
*/

BR_EXPORTENTRY (BR_FileSystemError) BR_JoinFileName(
	BR_BedString joinedName, 
	BS_StringLength maxLen, 
	BR_BedString drive, 
	BR_BedString path, 
	BR_BedString file);


BR_EXPORTENTRY (BR_FileSystemError) BR_Write(
	BR_FileHandle hf, 
	void FAR * p,
	BR_FileMeasurmentUnit cnt,
	BR_FileMeasurmentUnit FAR * actcnt);


BR_EXPORTENTRY (BR_FileSystemError) BR_Read(
	BR_FileHandle hf,
	void FAR * p, 
	BR_FileMeasurmentUnit cnt,
	BR_FileMeasurmentUnit FAR * actcnt);


BR_EXPORTENTRY (BR_FileSystemError) BR_SetEof(
	BR_FileHandle hf,
	BR_FileMeasurmentUnit pos);

BR_EXPORTENTRY (BR_FileSystemError) BR_GetEof(
	BR_FileHandle hf,
	BR_FileMeasurmentUnit FAR * eofPos);

BR_EXPORTENTRY (BR_Boolean) BR_Eof (
	BR_FileHandle hf,
	BR_FileSystemErrorPtr err);

BR_EXPORTENTRY (BR_FileSystemError) BR_SeekPosition(
	BR_FileHandle hf,
	BR_FileMeasurmentUnit dist,
	BR_FilePositionMode method,
	BR_FileMeasurmentUnit FAR * pos);

BR_EXPORTENTRY (BR_FileSystemError) BR_GetPosition(
	BR_FileHandle hf, 
	BR_FileMeasurmentUnit FAR * pos);

#ifdef __cplusplus
}
#endif

#endif

