/*========================================================================================
/ 
/      File:			BRSupDef.h
/      Release Version:	$ 1.0d1 $
/ 
/      Creation Date:	August 1989
/ 
/      COPYRIGHT 1989-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
/      RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
/      PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
/ 
/      THIS SOFTWARE Contains_LOOK PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
/      CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
/      EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
/ 
/      RESTRICTED RIGHTS LEGEND
/      Use, duplication, or disclosure by the Government is subject to restrictions as Set_LOOK
/      forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
/      Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
/      Cupertino, CA 95014.
/ 
/=======================================================================================*/

/*--------------------------------------------------------------------------------------
//	This file is part of the old international implementation.
//	The Bedrock team is in the process of designing a totally new approach.
//	For more details on the new approach please look in the 
//	":BEDROCK:INTL:INCLUDES:" folder.
//	The new approach departs from the close tie to characters and characterSets.
//	Instead it bases all internationalization efforts on locale based
//	characters, and character sets, with Unicode as the central set.
/--------------------------------------------------------------------------------------*/


#ifndef BRSUPDEF_H
#define BRSUPDEF_H

#ifndef BRSTDDEF_H
#include "BRStdDef.h"
#endif

#if defined(BR_BUILD_WIN)  && !defined(_INC_WINDOWS)
#include <windows.h>
#endif	

#if defined(BR_BUILD_MAC) && !defined(BRMACWIN_H)
#include <BRMacWin.h>
#endif	


/*
   Windows and Mac versions of Zortech each have their own quirks,
   so we want to be able to tell which one we're using
*/
#if defined BR_BUILD_WIN && defined __ZTC__
#ifndef __ZTCWIN__
#define __ZTCWIN__ __ZTC__
#endif
#endif


#ifdef __cplusplus
  extern "C" {
#endif

#ifdef BR_BUILD_MAC
#ifndef far
#define far
#endif
#ifndef near
#define near
#endif
#define PASCAL
#define cdecl
#define huge
#define _cdecl
#define CALLBACK
#endif

#ifdef BR_BUILD_WIN
#define PASCAL              pascal
#define CALLBACK            _far _pascal
#endif

#ifndef NOMINMAX

#ifndef max
#define max(a,b)            (((a) > (b)) ? (a) : (b))
#endif

#ifndef min
#define min(a,b)            (((a) < (b)) ? (a) : (b))
#endif
#endif

#ifdef BR_BUILD_WIN
#define BR_EXPORTENTRY(t)  t FAR PASCAL
#define BR_INTERNALENTRY       NEAR
#define BR_FASTENTRY     BR_EXPORTENTRY
#define EXPENTRY(t)    t FAR PASCAL
#define BR_INDIRECTENTRY       _pascal far
#define BR_INDIRECTENTRY2      FAR pascal
#endif

#ifdef BR_BUILD_MAC
#define BR_EXPORTENTRY(t)  t
#define BR_INTERNALENTRY
#define BR_FASTENTRY   BR_EXPORTENTRY
#define EXPENTRY(t)    t
#define BR_INDIRECTENTRY
#define BR_INDIRECTENTRY2
#define near
#define far
#define FAR                 far
#define NEAR                near
#define LONG                long
#define VOID                void
#endif


typedef unsigned short BR_SEL;  /*SELectors are similar to segments*/

/* Create_LOOK untyped far pointer from selector and Offset_LOOK */
#define BR_MAKEP(sel, off)     ((void FAR *)BR_MAKEULONG(off, sel))

/* Extract selector or Offset_LOOK from far pointer */
#define BR_SELECTOROF(p)       (((unsigned short FAR *)&(p))[1])
#define BR_OFFSETOF(p)     (((unsigned short FAR *)&(p))[0])

/* Cast any variable to an instance of the specified type. */
#define BR_MAKETYPE(v, type)   (*((type far *)&v))

/* Calculate the byte Offset_LOOK of a field in a structure of type type. */
#define BR_FIELDOFFSET(type, field)    ((short)&(((type *)0)->field))

/* Combine l & h to form a 32 bit quantity. */
#define BR_MAKEULONG(l, h)  ((unsigned long)(((unsigned short)(l)) | (((unsigned long)((unsigned short)(h))) << 16)))

/* Combine l & h to form a 16 bit quantity. */
#define BR_MAKEUSHORT(l, h) (((unsigned short)(l)) | (((unsigned short)(h)) << 8))
#define BR_MAKESHORT(l, h)  ((short)MAKEUSHORT(l, h))

/* Extract high and low order parts of 16 and 32 bit quantity */
#define BR_LOUCHAR(w)  ((unsigned char)(w))
#define BR_HIUCHAR(w)  ((unsigned char)(((unsigned short)(w) >> 8) & 0xff))
#define BR_LOUSHORT(l) ((unsigned short)(l))
#define BR_HIUSHORT(l) ((unsigned short)(((unsigned long)(l) >> 16) & 0xffff))



typedef BR_Float FAR * BR_FloatPtr;
#define BR_FLOAT_MAX10EXP 308
#define BR_FLOAT_MIN10EXP (-307)


typedef long                    BR_StringCharacter;
typedef char FAR*               BR_StringPtr;
typedef unsigned short  		BR_UnicodeCharacter;
typedef unsigned short FAR *	BR_UnicodeString;

#ifdef Bierman
/* Types use for passing & returning polymorphic values */
typedef unsigned short WPARAM;
typedef long LPARAM;
typedef long LRESULT;
#endif


#ifdef BR_BUILD_MAC
typedef unsigned short      HFILE;
#endif

typedef unsigned char FAR * BR_PascalString;        /*Length byte string - pascal string*/
typedef  char FAR * BR_AnsiString;        /*zero terminated string*/
typedef  char FAR * BR_BedString;      /*Zero terminated pascal string*/
typedef const  char FAR * BR_AnsiStringConst; /*Constant BR_AnsiString*/
typedef const unsigned char FAR * BR_PascalStringConst; /*Constant BR_PascalString*/
typedef const  char FAR * BR_StringConst; /*Constant BR_StringPtr*/


/* These macros get a character into a singular form from a BR_StringPtr pointer */

#define BR_GetSBCSStringCharacter(p) (BR_MAKEULONG(((unsigned short)(*((unsigned char FAR *)(p)))),0))

#ifdef BR_BUILD_WIN
#define BR_GetDBCSStringCharacter(p) (BR_MAKEULONG(0,BR_MAKEUSHORT((*(((unsigned char FAR *)(p))+1)),(*((unsigned char FAR *)(p))))))
#endif

#ifdef BR_BUILD_MAC
#define BR_GetDBCSStringCharacter(p) (BR_MAKEULONG(((unsigned short)(*((unsigned short FAR *)(p)))),0))
#endif

#ifndef BUILD_DBCS
#define BR_GetStringCharacter(p) BR_GetSBCSStringCharacter(p)
#endif

typedef enum
   {
   BR_SysErr_kNoError,
   BR_SysErr_kError,
   BR_SysErr_kFastBaseNotSet,
   BR_SysErr_kFastDateTimeOverflow,
   BR_SysErr_kClockError,
   BR_SysErr_kInvalidDateTimeStructure
   } BR_SystemError;

#define BR_MAXIMUM_PROCESS_IDS 256

typedef long BR_VMHandle;

typedef long (BR_INDIRECTENTRY2 * PFNWP) ();

/* Used in BRWFile.C - I still question it's usage */

#define BR_MAXIMUM_FILE_STRINGLENGTH    128 /*I really question this - RAB (either 256-BR_BEDSTRING_OVERHEAD or 65536-BR_BEDSTRING_OVERHEAD) */
#define BR_MAX_FONT_SIZES  20


typedef BR_VMHandle BR_FileHandle;     /*This is a cookie of no meaning to anyone else*/

/* bedrock resource ids */
#define BR_OVERWRITE   1
#define BR_NOWRITE     2
#define BR_CUSTOM      3
#define BR_ILLFNM      4

#ifdef __cplusplus
   }
#endif

#endif
