/*========================================================================================
/ 
/      File:			BRAssert.h
/      Release Version:	$ 1.0d1 $
/ 
/      Creation Date:	Thu 11-Oct-1990
/ 
/      COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
/      RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
/      PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
/ 
/      THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
/      CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
/      EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
/ 
/      RESTRICTED RIGHTS LEGEND
/      Use, duplication, or disclosure by the Government is subject to restrictions as Set
/      forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
/      Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
/      Cupertino, CA 95014.
/ 
/=======================================================================================*/

#ifndef BRASSERT_H
#define BRASSERT_H

#ifndef  BRSUPDEF_H
#include "BRSupDef.h"
#endif


#ifdef __cplusplus
  extern "C" {
#endif


#ifdef NDEBUG
   #define BedAssert(exp)
   #define BedAssertMsg(exp,msg)
   #define BedDebugMsg(msg)
#else
   #define BedAssert2(x)  #x
   #define BedAssert1(x)  BedAssert2(x)

#ifdef BR_BUILD_MAC
      #define BedAssert(exp)	    if (!(exp)) printf(__FILE__ " : Line " BedAssert1(__LINE__) " : Test " #exp)
      #define BedAssertMsg(exp,msg) if (!(exp)) printf(__FILE__ " : Line " BedAssert1(__LINE__) " : "      msg)
      #define BedDebugMsg(msg)			printf(__FILE__ " : Line " BedAssert1(__LINE__) " : "      msg)

   #elif defined BUILD_PM
      #define BedAssert(exp)	    if (!(exp)) \
				       WinMessageBox( \
					  HWND_DESKTOP, \
					  HWND_DESKTOP, \
					  __FILE__ " : Line " BedAssert1(__LINE__) " : Test " #exp, \
					  "BedAssert", \
					  0, \
					  MB_ICONEXCLAMATION | MB_MOVEABLE)
      #define BedAssertMsg(exp,msg) if (!(exp)) \
				       WinMessageBox( \
					  HWND_DESKTOP, \
					  HWND_DESKTOP, \
					  __FILE__ " : Line " BedAssert1(__LINE__) " : " msg, \
					  "BedAssertMsg", \
					  0, \
					  MB_ICONEXCLAMATION | MB_MOVEABLE)
      #define BedDebugMsg(msg)	       WinMessageBox( \
					  HWND_DESKTOP, \
					  HWND_DESKTOP, \
					  __FILE__ " : Line " BedAssert1(__LINE__) " : " msg, \
					  "BedDebugMsg", \
					  0, \
					  MB_ICONEXCLAMATION | MB_MOVEABLE)

   #elsif defined BR_BUILD_WIN
      #define BedAssert(exp)	    if (!(exp)) \
				       MessageBox( \
					  NULL, \
					  __FILE__ " : Line " BedAssert1(__LINE__) " : Test " #exp, \
					  "BedAssert", \
					  MB_ICONEXCLAMATION)
      #define BedAssertMsg(exp,msg) if (!(exp)) \
				       MessageBox( \
					  NULL, \
					  __FILE__ " : Line " BedAssert1(__LINE__) " : " msg, \
					  "BedAssertMsg", \
					  MB_ICONEXCLAMATION)
      #define BedDebugMsg(msg)	       MessageBox( \
					  NULL, \
					  __FILE__ " : Line " BedAssert1(__LINE__) " : " msg, \
					  "BedDebugMsg", \
					  MB_ICONEXCLAMATION)
   #endif
#endif

#ifdef __cplusplus
}
#endif
#endif

