#ifndef BRCHARAC_H
#define BRCHARAC_H
//========================================================================================
//
//     File:		BRCharac.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	4/2/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRSTDDEF_H
#include "BRStdDef.h"
#endif

typedef unsigned long BR_CharacterCount;
typedef unsigned long BR_CharacterPosition;

enum {kNulCharacter=0};

//----------------------------------------------------------------------------------------
//	BR_StringLength
//----------------------------------------------------------------------------------------

#ifdef qConstTemplateParameterBugFixed
// Early beta versions of Symantec C++ have problems with template parameters modified by const.
template <class tCharacter>
BR_CharacterCount BR_StringLength(const tCharacter *string);

template <class tCharacter>
BR_CharacterCount BR_StringLength(const tCharacter *string)
{
	register const tCharacter *s = string;
	while (*s++ != tCharacter(0))
	{}
	return (s - string - 1);
}
#else
BR_CharacterCount BR_StringLength(const BR_Char * string);
BR_CharacterCount BR_StringLength(const BR_PascalChar * string);
BR_CharacterCount BR_StringLength(const BR_WideChar * string);
#endif

//----------------------------------------------------------------------------------------
//	BR_BlockMove
//----------------------------------------------------------------------------------------

#ifdef qConstTemplateParameterBugFixed
template <class tCharacter>
void BR_BlockMove(const tCharacter *source, tCharacter *destination, BR_CharacterCount numberItems);
	// Assumes move will work when source and destination overlap, from either direction!
#else
void BR_BlockMove(const BR_Char *source, BR_Char *destination, BR_CharacterCount numberItems);
void BR_BlockMove(const BR_PascalChar *source, BR_PascalChar *destination, BR_CharacterCount numberItems);
void BR_BlockMove(const BR_WideChar *source, BR_WideChar *destination, BR_CharacterCount numberItems);
#endif

#endif
