//========================================================================================
//
//      File:		BRTables.h
//      Release Version:	1.0d1
// 
//      Creation Date:		March 1993
// 
//      COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//      RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//      PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
// 
//      THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//      CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//      EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
// 
//      RESTRICTED RIGHTS LEGEND
//      Use, duplication, or disclosure by the Government is subject to restrictions as Set
//      forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//      Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//      Cupertino, CA 95014.
// 
//=======================================================================================


#ifndef	BRTABLES_H
#define BRTABLES_H
#endif


#ifndef	BRWRISYS_H
#include "BRWRISYS.H"
#endif


//---------------------------------------------------------------------------------------
//	Forward class declarations
//---------------------------------------------------------------------------------------

class BR_CLocale;
class BR_CScriptProperties;
class	 BR_CFormat;
class BR_CCharacterAttributes;

//========================================================================================
//	CLASS BR_CTable	
//========================================================================================

class BR_CTable 
{		//	this class will be using collections to represent the data
public :
	BR_CTable();
	~BR_CTable();
protected :

private :
	
};

//========================================================================================
//	CLASS BR_CTranslationTable	
//========================================================================================

class BR_CTranslationTable : public BR_CTable
{
public:
	BR_CTranslationTable();
	~BR_CTranslationTable();

	BR_CUnicode CharacterToUnicode(BR_TCharacter sourceCharacter,
								   BR_CCharacterSet::CharacterSetID sourceCodePage = gCurrentLocale.fExternalCharacterSet);

	BR_CUnicode* StringToUnicode(BR_TCharacter* sourceString,
								 BR_CCharacterSet::CharacterSetID sourceCodePage = gCurrentLocale.fExternalCharacterSet);

	BR_TCharacter CharacterFromUnicode(BR_CUnicode sourceCharacter,
									   BR_CCharacterSet::CharacterSetID targetCodePage = gCurrentLocale.fExternalCharacterSet);

	BR_TCharacter* StringFromUnicode(BR_CUnicode* sourceString,
									 BR_CCharacterSet::CharacterSetID targetCodePage = gCurrentLocale.fExternalCharacterSet);

protected:
	short UniToCPXlateCharacter(unsigned short Character,
								void* TranslationTablePtr);
	void* BedLoadTransTable(unsigned short MapResourceID);

private:

};




//========================================================================================
//	CLASS BR_CCasingTable	
//========================================================================================

class BR_CCasingTable : public BR_CTable
{
public:
	BR_CString ToUpper(const BR_CString inString);
	BR_CString ToLower(const BR_CString inString);
protected:
	BR_CTable* LoadCasingTable();
	BR_CTable* LoadCasingTable(BR_LocaleID = UNICODE);
	BR_CTable* LoadCasingTable(const BR_CLocale someLocale);
private:

};




