//========================================================================================
//
//      File:		BRScript.h
//      Release Version:	1.0d1
// 
//      Creation Date:		March 1993
// 
//      COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//      RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//      PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
// 
//      THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//      CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//      EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
// 
//      RESTRICTED RIGHTS LEGEND
//      Use, duplication, or disclosure by the Government is subject to restrictions as Set
//      forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//      Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//      Cupertino, CA 95014.
// 
//=======================================================================================


#ifndef	BRSCRIPT_H
#define	BRSCRIPT_H
#endif


#ifndef	BRWRISYS_H
#include "BRWRISYS.H"
#endif



//========================================================================================
//	CLASS BR_CScriptProperties
//========================================================================================
class BR_CScriptProperties
{
public:

	BR_Direction GetBookBindingDirection() const;
	BR_Direction GetFacingPagesDirection() const;
	BR_Direction GetParagraphFlowDirection() const;
	BR_Direction GetLineFlowDirection() const;
	BR_Direction GetLineOrientation() const;
	BR_Direction GetCharacterDirection() const;
	BR_Direction GetCharacterOrientation() const;

	BR_Boolean SetBookBindingDirection();
	BR_Boolean SetFacingPagesDirection();
	BR_Boolean SetParagraphFlowDirection();
	BR_Boolean SetLineFlowDirection();
	BR_Boolean SetLineOrientation();
	BR_Boolean SetCharacterDirection();
	BR_Boolean SetCharacterOrientation();

private:
	BR_Locale* fLocale;
	BR_Direction BookBindingDirection;			//	direction of overall page flow in a book
	BR_Direction FacingPagesDirection;			//	direction of page flow between 2 facing pages
	BR_Direction ParagraphFlowDirection;		//	direction of paragraph flow
	BR_Direction LineFlowDirection;				//	direction of line flow (toward location of next character) aka escapement
	BR_Direction LineOrientation;				//	direction of up for the line
	BR_Direction CharacterDirection;			//	direction of character (affects bidi algorithm)
	BR_Direction CharacterOrientation;			//	which way is up for the character
	BR_Boolean fDoesHyphenate;
	BR_Boolean fRequiresInputMethod;
};




//	it is neccessary to keep BR_Direction a separate type, because we may want to
//	make it into a class with a sophisticated set of functionality, to allow for
//	non-linear directionality, like flow on a path, Bidi, or indic script.

typedef enum BR_Direction
{
	BotomUp=0, 
	LeftToRight=90, 
	TopDown=180, 
	RightToLeft=270
};


/*
		unsigned char		GetBreakBeforeTable();					
		unsigned char		GetBreakAfterTable();					
		unsigned char		GetCharacterAttributes();	
		unsigned char		GetToUpperCaseTable();		
		unsigned char		GetToLowerCaseTable();		

		BR_Boolean		SetBreakBeforeTable();					
		BR_Boolean		SetBreakAfterTable();					
		BR_Boolean		SetCharacterAttributes();	
		BR_Boolean		SetToUpperCaseTable();		
		BR_Boolean		SetToLowerCaseTable();		

		unsigned char		BreakBeforeTable[255];		//	
		unsigned char		BreakAfterTable[255];			//	
		unsigned char		CharacterAttributes[255];	//
		unsigned char		ToUpperCaseTable[255];		//
		unsigned char		ToLowerCaseTable[255];		//
*/