//========================================================================================
//
//      File:		BRITerat.h
//      Release Version:	1.0d1
// 
//      Creation Date:		March 1993
// 
//      COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//      RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//      PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
// 
//      THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//      CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//      EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
// 
//      RESTRICTED RIGHTS LEGEND
//      Use, duplication, or disclosure by the Government is subject to restrictions as Set
//      forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//      Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//      Cupertino, CA 95014.
// 
//=======================================================================================

#ifndef	BRITERAT_H
#define	BRITERAT_H
#endif


#ifndef	BRWRISYS_H
#include "BRWRISYS.H"
#endif


//---------------------------------------------------------------------------------------
//	Forward class declarations
//---------------------------------------------------------------------------------------

class BR_CLocale;
class BR_CScriptProperties;
class	 BR_CFormat;
class BR_CCharacterAttributes;


//========================================================================================
//	CLASS BR_CIntelligentIterator
//========================================================================================


class BR_CIntelligentIterator : public BR_CIterator
{
public:
	Next();
	Previous();

protected:

private:
	BR_CUnicode* aString;
};





//========================================================================================
//	CLASS BR_CBaseCharacterIterator
//
//	example of an intelligent iterator
//========================================================================================

class BR_CBaseCharacterIterator : public BR_CIntelligentIterator
{
public:
	BR_Boolean BR_CBaseCharacterIterator(BR_CUnicodeString aString);
	~BR_CBaseCharacterIterator();

	NextBaseCharacter();
	PreviousBaseCharacter();
protected:

private:
	//	we will possibly be using a BC2.0 set  to hold set of base characters 
};






//========================================================================================
//	CLASS BR_CWordIterator
//========================================================================================

	//	Totally language dependent

class BR_CWordIterator : public BR_CIntelligentIterator
{
public:
	BR_Boolean BR_CWordIterator(BR_CUnicodeString aString);
	~BR_CWordIterator();

	NextWord();
	PreviousWord();

protected:

private:
};




//========================================================================================
//	CLASS BR_CKinsokuIterator
//========================================================================================


class BR_CKinsokuIterator : public BR_CIntelligentIterator
{
public:
	BR_Boolean BR_CKinsokuIterator(BR_CUnicodeString aString);
	~BR_CKinsokuIterator();

	GetNextValidKinsokuLineBreak();
	GetPreviousValidKinsokuLineBreak();
protected:

private:
};




//========================================================================================
//	CLASS BR_CShapingIterator
//========================================================================================


class BR_CShapingIterator : public BR_CIntelligentIterator
{
public:
	BR_Boolean BR_CShapingIterator(BR_CUnicodeString aString);
	~BR_CShapingIterator();

	GetNextInitialCharacter();
	GetNextMedialCharacter();
	GetNextFinalCharacter();
	GetNextStandAloneCharacter();

	GetPreviousInitialCharacter();
	GetPreviousMedialCharacter();
	GetPreviousFinalCharacter();
	GetPreviousStandAloneCharacter();

protected:

private:
};





//========================================================================================
//	CLASS BR_CBidiIterator
//========================================================================================


class BR_CBidiIterator : public BR_CIntelligentIterator
{
public:
	BR_Boolean BR_CBidiIterator(BR_CUnicodeString aString);
	~BR_CBidiIterator();

	NextLogicalCharater();
	PreviousLogicalCharater();

	NextVisualCharacter();
	PreviousVisualCharacter();

protected:

private:
};


