#ifndef BRMINMAX_H
#define BRMINMAX_H

//========================================================================================
//
//     File:			BRMinMax.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	1/20/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

//========================================================================================
// These macros are used to create inline functions that find the minimum or maximum of
// two given values. They should be templates soon.
//========================================================================================

#ifdef min
#undef min
#endif

#ifdef max
#undef max
#endif

#define MIN(TYPE)   inline TYPE min(const TYPE a, const TYPE b) {return((a < b) ? a : b);}
#define MAX(TYPE)   inline TYPE max(const TYPE a, const TYPE b) {return((a > b) ? a : b);}

// These create the minimum and maximum inline functions defined above

MIN(short)
MIN(unsigned short)
MIN(long)
MIN(unsigned long)
MAX(short)
MAX(unsigned short)
MAX(long)
MAX(unsigned long)

//========================================================================================
// Used to create absolute value functions
//========================================================================================

#define ABS(TYPE) inline TYPE abs(const TYPE a) {return((a < TYPE(0)) ? -a : a);}

ABS(short)
ABS(long)

#endif
