//  The C++ Booch Components (Version 2.0)
//  (C) Copyright 1990-1993 Grady Booch. All Rights Reserved.
//
//  BCSortV.h
//
//  This file contains the declaration of the vector sorting tools.

#ifndef BCSORTV_H
#define BCSORTV_H 1

#include "BCType.h"

// Vector sorting abstract base class

template<class Item, class Sequence>
class BC_TSort {
public:

  BC_TSort();
  BC_TSort(BC_Boolean (*BC_IsLessThan)(const Item& x, const Item& y));
  virtual ~BC_TSort();
  
  virtual void
     SetIsLessThanFunction(BC_Boolean (*BC_IsLessThan)(const Item& x, const Item& y));
  virtual void Sort(Sequence&) = 0;
  
protected:

  BC_Boolean (*fRepIsLessThan)(const Item&, const Item&);
  void Swap(Sequence&, BC_Index i, BC_Index j);
  
};

// Quick Sort

template<class Item, class Sequence>
class BC_TQuickSort : public BC_TSort<Item, Sequence> {
public:

  BC_TQuickSort();
  BC_TQuickSort(BC_Boolean (*BC_IsLessThan)(const Item& x, const Item& y));
  virtual ~BC_TQuickSort();

  virtual void Sort(Sequence&);

protected:

  virtual void SortRecursive(Sequence&, BC_Index left, BC_Index right);
  
};

#endif
