//  The C++ Booch Components (Version 2.0)
//  (C) Copyright 1990-1993 Grady Booch. All Rights Reserved.
//
//  BCSearcL.h
//
//  This file contains the declaration of the list searching tools.

#ifndef BCSEARCL_H
#define BCSEARCL_H 1

#include "BCType.h"

// List searching abstract base class

template<class Item, class List>
class BC_TListSearch {
public:

  BC_TListSearch();
  BC_TListSearch(BC_Boolean (*BC_IsEqual)(const Item& x, const Item& y));
  virtual ~BC_TListSearch();
  
  virtual void
    SetIsEqualFunction(BC_Boolean (*BC_IsEqual)(const Item& x, const Item& y));
  virtual List Location(const List& target, const Item& key) = 0;
    
protected:

  BC_Boolean (*fRepIsEqual)(const Item& x, const Item& y);

};

// Sequential searching class
  
template<class Item, class List>
class BC_TSequentialListSearch : public BC_TListSearch<Item, List> {
public:

  BC_TSequentialListSearch();
  BC_TSequentialListSearch(BC_Boolean (*BC_IsEqual)(const Item& x, const Item& y));
  virtual ~BC_TSequentialListSearch();
  
  virtual List Location(const List& target, const Item& key);

};

// Ordered searching class
  
template<class Item, class List>
class BC_TOrderedListSearch : public BC_TListSearch<Item, List> {
public:

  BC_TOrderedListSearch();
  BC_TOrderedListSearch 
    (BC_Boolean (*BC_IsEqual)(const Item& x, const Item& y),
     BC_Boolean (*BC_IsLessThan)(const Item& x, const Item& y));
  virtual ~BC_TOrderedListSearch();
  
  virtual void
    SetIsLessThanFunction(BC_Boolean (*BC_IsEqual)(const Item& x, const Item& y));
  virtual List Location(const List& target, const Item& key);

protected:

  BC_Boolean (*fRepIsLessThan)(const Item& x, const Item& y);

};

#endif
