//  The C++ Booch Components (Version 2.0)
//  (C) Copyright 1990-1993 Grady Booch. All Rights Reserved.
//
//  BCStacD.h
//
//  This file contains the declaration of the dynamic stack.

#ifndef BCSTACD_H
#define BCSTACD_H 1

#include "BCDynami.h"
#include "BCStac.h"

// Dynamic stack

template<class Stack_Item, class Storage_Manager>
class BC_DynamicStack : public BC_Stack<Stack_Item> {
public:

  BC_DynamicStack();
  BC_DynamicStack(BC_Index ChunkSize);
  BC_DynamicStack(const BC_DynamicStack<Stack_Item, Storage_Manager>&);
  virtual ~BC_DynamicStack();

  virtual BC_Stack<Stack_Item>& operator=(const BC_Stack<Stack_Item>&);
  virtual BC_Stack<Stack_Item>& operator=(const BC_DynamicStack<Stack_Item, Storage_Manager>&);
  virtual BC_Boolean operator==(const BC_Stack<Stack_Item>&) const;
  virtual BC_Boolean operator==(const BC_DynamicStack<Stack_Item, Storage_Manager>&) const;
  BC_Boolean operator!=(const BC_DynamicStack<Stack_Item, Storage_Manager>&) const;

  virtual void SetChunkSize(BC_Index ChunkSize);
  virtual void Preallocate(BC_Index new_length);
  virtual void Clear();
  virtual void Push(const Stack_Item&);
  virtual void Pop();
    
  virtual BC_Index ChunkSize() const;
  virtual BC_Index Depth() const;
  virtual BC_Boolean IsEmpty() const;
  virtual const Stack_Item& Top() const;

  static void* operator new(size_t);
  static void operator delete(void*, size_t);

protected:

  BC_TDynamic<Stack_Item, Storage_Manager> fRep;  

  virtual void Purge();
  virtual void Add(const Stack_Item&);
  virtual BC_Index Cardinality() const;
  virtual const Stack_Item& Item(BC_Index) const;

};

#endif
