//  The C++ Booch Components (Version 2.0)
//  (C) Copyright 1990-1993 Grady Booch. All Rights Reserved.
//
//  BCStacB.h
//
//  This file contains the declaration of the bounded stack.

#ifndef BCSTACB_H
#define BCSTACB_H 1

#include "BCBound.h"
#include "BCStac.h"

// Bounded stack

template<class Stack_Item, BC_Index Size>
class BC_BoundedStack : public BC_Stack<Stack_Item> {
public:

  BC_BoundedStack();
  BC_BoundedStack(const BC_BoundedStack<Stack_Item, Size>&);
  virtual ~BC_BoundedStack();

  virtual BC_Stack<Stack_Item>& operator=(const BC_Stack<Stack_Item>&);
  virtual BC_Stack<Stack_Item>& operator=(const BC_BoundedStack<Stack_Item, Size>&);
  virtual BC_Boolean operator==(const BC_Stack<Stack_Item>&) const;
  virtual BC_Boolean operator==(const BC_BoundedStack<Stack_Item, Size>&) const;
  BC_Boolean operator!=(const BC_BoundedStack<Stack_Item, Size>&) const;

  virtual void Clear();
  virtual void Push(const Stack_Item&);
  virtual void Pop();
    
  virtual BC_Index Available() const;
  virtual BC_Index Depth() const;
  virtual BC_Boolean IsEmpty() const;
  virtual const Stack_Item& Top() const;

protected:

  BC_TBounded<Stack_Item, Size> fRep;  

  virtual void Purge();
  virtual void Add(const Stack_Item&);
  virtual BC_Index Cardinality() const;
  virtual const Stack_Item& Item(BC_Index) const;

  static void* operator new(size_t);
  static void operator delete(void*, size_t);

};

#endif
