//  The C++ Booch Components (Version 2.0)
//  (C) Copyright 1990-1993 Grady Booch. All Rights Reserved.
//
//  BCQue.h
//
//  This file contains the declaration of the queue abstract base class
//  and its iterators.

#ifndef BCQUE_H
#define BCQUE_H 1

#include "BCType.h"

template<class Queue_Item>
class BC_TQueueActiveIterator;

template<class Queue_Item>
class BC_TQueuePassiveIterator;

// Queue abstract base class

template<class Queue_Item>
class BC_TQueue {
public:

  BC_TQueue();
  BC_TQueue(const BC_TQueue<Queue_Item>&);
  virtual ~BC_TQueue();

  virtual BC_TQueue<Queue_Item>& operator=(const BC_TQueue<Queue_Item>&);
  virtual BC_Boolean operator==(const BC_TQueue<Queue_Item>&) const;
  BC_Boolean operator!=(const BC_TQueue<Queue_Item>&) const;
  
  virtual void Clear() = 0;
  virtual void Append(const Queue_Item&) = 0;
  virtual void Pop() = 0;
  virtual void Remove(BC_Index at) = 0;

  virtual BC_Index Length() const = 0;
  virtual BC_Boolean IsEmpty() const = 0;
  virtual const Queue_Item& Front() const = 0;
  virtual BC_Extended_Index Location(const Queue_Item&) const = 0;

protected:

  virtual void Purge() = 0;
  virtual void Add(const Queue_Item&) = 0;
  virtual BC_Index Cardinality() const = 0;
  virtual const Queue_Item& Item(BC_Index) const = 0;

  virtual void Lock();
  virtual void Unlock();

private:

  friend class BC_TQueueActiveIterator<Queue_Item>;
  friend class BC_TQueuePassiveIterator<Queue_Item>;
  
};

// Queue iterators

template <class Queue_Item>
class BC_TQueueActiveIterator {
public:

  BC_TQueueActiveIterator(const BC_TQueue<Queue_Item>&);
  ~BC_TQueueActiveIterator();
  
  void Reset();
  BC_Boolean Next();

  BC_Boolean IsDone() const;
  const Queue_Item* Item() const;
  
protected:

  const BC_TQueue<Queue_Item>& fRepQueue;
  BC_Extended_Index fRepIndex;
  
};

template <class Queue_Item>
class BC_TQueuePassiveIterator {
public:

  BC_TQueuePassiveIterator(const BC_TQueue<Queue_Item>&);
  ~BC_TQueuePassiveIterator();
  
  BC_Boolean Apply(BC_Boolean (*)(const Queue_Item&));
  
protected:

  const BC_TQueue<Queue_Item>& fRepQueue;

};

#endif
