#ifndef BRPOSTEX_H
#define BRPOSTEX_H
//========================================================================================
//
//	This source file is a component of the Bedrock Class Library
//
//	File:				BRPostEx.h
//	Release Version:	$ 1.0d1 $
//
//	Creation Date:		01/09/93
//
//	COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//	RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//	PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//	THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//	CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//	EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//	RESTRICTED RIGHTS LEGEND
//	Use, duplication, or disclosure by the Government is subject to restrictions as Set
//	forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//	Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//	Cupertino, CA 95014.
//
//========================================================================================

#ifndef   BREXCEPT_H
#include "BRExcept.h"
#endif

#ifndef   BRSPOSTE_H
#include "BRSPostE.h"
#endif

#ifndef   BREXCTAS_H
#include "BRExcTas.h"
#endif

//========================================================================================
// CLASS BR_CPostedException
//========================================================================================

class BR_CPostedException
{

public:

	static void Initialize(size_t maxExceptionSize);
		// Initialize.  Should only be called once, before any exception is posted.
		// Exception buffer is allocated as maxExceptionSize bytes.
		
	static void Terminate();
		// Cleanup.  Releases exception buffer.

	static void PostException(const _BR_CException& exception);
		// Post an exception.
		// No-op if posted exception already pending.
	
	static short IsPendingException();
		// Returns 1 if an exception has been posted and not yet thrown.
		// Returns 0 otherwise.
	
	static void ThrowPostedException();
		// Throw the posted exception.
		// It is a no-op to invoke this function if no exception is pending.

private:

	static void SetHavePendingException(short pending);
		// Setter for pending exception flag.
		// Use public IsPendingException for getter.

	static void SetPostedExceptionBuffer(_BR_CException* exceptionBuffer);
		// Setter for pointer to exception buffer.

	static _BR_CException* GetPostedExceptionBuffer();
		// Getter for pointer to exception buffer.

	static void SetPostedExceptionBufferSize(size_t bufferSize);
		// Setter for exception buffer size.

	static size_t GetPostedExceptionBufferSize();
		// Getter for exception buffer size.

	static void SetPostedExceptionsInitialized(short isInitialized);
		// Setter for posted exceptions initialized flag.

	static short GetPostedExceptionsInitialized();
		// Getter for posted exceptions initialized flag.

};


//========================================================================================
// BR_CPostedException inline functions (Static Task Globals Versions)
//========================================================================================

#ifdef BR_STATIC_TASK_GLOBALS

inline short BR_CPostedException::IsPendingException()
{
	return BR_CExceptionTaskGlobals::gExceptionTaskGlobals.
						gBedPostedExceptionGlobals.gPending;
}

inline void BR_CPostedException::SetHavePendingException(short pending)
{
	BR_CExceptionTaskGlobals::gExceptionTaskGlobals.
						gBedPostedExceptionGlobals.gPending = pending;
}

inline void BR_CPostedException::SetPostedExceptionBuffer(_BR_CException* exceptionBuffer)
{
	BR_CExceptionTaskGlobals::gExceptionTaskGlobals.
						gBedPostedExceptionGlobals.gPostedException = exceptionBuffer;
}

inline _BR_CException* BR_CPostedException::GetPostedExceptionBuffer()
{
	return BR_CExceptionTaskGlobals::gExceptionTaskGlobals.
						gBedPostedExceptionGlobals.gPostedException;
}

inline void BR_CPostedException::SetPostedExceptionBufferSize(size_t bufferSize)
{
	BR_CExceptionTaskGlobals::gExceptionTaskGlobals.
						gBedPostedExceptionGlobals.gMaxPostedSize = bufferSize;
}

inline size_t BR_CPostedException::GetPostedExceptionBufferSize()
{
	return BR_CExceptionTaskGlobals::gExceptionTaskGlobals.
						gBedPostedExceptionGlobals.gMaxPostedSize;
}

inline void BR_CPostedException::SetPostedExceptionsInitialized(short isInitialized)
{
	BR_CExceptionTaskGlobals::gExceptionTaskGlobals.
						gBedPostedExceptionGlobals.gInitialized = isInitialized;
}

inline short BR_CPostedException::GetPostedExceptionsInitialized()
{
	return BR_CExceptionTaskGlobals::gExceptionTaskGlobals.
						gBedPostedExceptionGlobals.gInitialized;
}

#endif

//========================================================================================
// BR_CPostedException inline functions (Windows Versions)
//========================================================================================

#ifndef BR_STATIC_TASK_GLOBALS

inline short BR_CPostedException::IsPendingException()
{
	return BR_CExceptionTaskGlobals::GetTaskGlobals()->
						gBedPostedExceptionGlobals.gPending;
}

inline void BR_CPostedException::SetHavePendingException(short pending)
{
	BR_CExceptionTaskGlobals::GetTaskGlobals()->
						gBedPostedExceptionGlobals.gPending = pending;
}

inline void BR_CPostedException::SetPostedExceptionBuffer(_BR_CException* exceptionBuffer)
{
	BR_CExceptionTaskGlobals::GetTaskGlobals()->
						gBedPostedExceptionGlobals.gPostedException = exceptionBuffer;
}

inline _BR_CException* BR_CPostedException::GetPostedExceptionBuffer()
{
	return BR_CExceptionTaskGlobals::GetTaskGlobals()->
						gBedPostedExceptionGlobals.gPostedException;
}

inline void BR_CPostedException::SetPostedExceptionBufferSize(size_t bufferSize)
{
	BR_CExceptionTaskGlobals::GetTaskGlobals()->
						gBedPostedExceptionGlobals.gMaxPostedSize = bufferSize;
}

inline size_t BR_CPostedException::GetPostedExceptionBufferSize()
{
	return BR_CExceptionTaskGlobals::GetTaskGlobals()->
						gBedPostedExceptionGlobals.gMaxPostedSize;
}

inline void BR_CPostedException::SetPostedExceptionsInitialized(short isInitialized)
{
	BR_CExceptionTaskGlobals::GetTaskGlobals()->
						gBedPostedExceptionGlobals.gInitialized = isInitialized;
}

inline short BR_CPostedException::GetPostedExceptionsInitialized()
{
	return BR_CExceptionTaskGlobals::GetTaskGlobals()->
						gBedPostedExceptionGlobals.gInitialized;
}

#endif

#endif
