#ifndef BREXCEPT_H
#define BREXCEPT_H
//========================================================================================
//
//     File:			BRExcept.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	June 1, 1992
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   BRMETACL_H
#include "BRMetaCl.h"
#endif

#ifndef BRPRIDEB_H
#include "BRPriDeb.h"
#endif

//========================================================================================
// CLASS _BR_CException
//========================================================================================

class _BR_CException
{
public:
	virtual ~_BR_CException();
	_BR_CException();
	
	int __IsKindOf(_BR_CMetaClass* aClass);
		// Returns 1 if this object is a kind of aClass, i.e. same or subclass of aClass.

	virtual _BR_CMetaClass* MyClass() const;
		// Returns a pointer to this exception's metaclass object.
		
	size_t GetSize() const;
		// Returns the size of this object, using info from its metaclass
		// This method is not virtual, but will work correctly since MyClass is virtual.
	
	virtual void Copy(void *p, size_t maxObjectSize) const;
		// Copies this object.  This method does a bitwise copy, but subclasses
		//   must override to perform a deep copy.

	void Delete();
		// Calls the virtual destructor, but does not attept to delete storage.

#ifdef BR_DEBUG
	char *const GetClassName() const;
		// Returns the class name of this object, as a string.
		// This method is not virtual, but will work correctly since MyClass is virtual.

#endif

#ifdef BR_BUILD_WIN
	static _BR_CMetaClass* __StaticGetClass();
		// A static method similar to MyClass, necessary for Windows since Lnk2Exp
		//   currently doesn't export data.

#endif

#ifdef BR_DEBUG
	short	fIsValid;
#endif
	_BR_CLASS_DEFINE(_BR_CException);
};

//========================================================================================
// CLASS _BR_CException inline functions
//========================================================================================

inline size_t _BR_CException::GetSize() const
{
	BR_PRIMITIVE_ASSERT(fIsValid==1);
	return MyClass()->fInstanceSize;
}

#ifdef BR_DEBUG
inline char *const _BR_CException::GetClassName() const
{
	BR_PRIMITIVE_ASSERT(fIsValid==1);
	return MyClass()->GetClassName();
}
#endif

inline void _BR_CException::Delete()
{
	BR_PRIMITIVE_ASSERT(fIsValid==1);
#ifdef _MPWCFRONT
	// CFront is bizarre.  It won't allow the unscoped destructor name, but the scoped 
	// name is dispatched virtually, even though ARM says scoped names are never virtual.
	this->_BR_CException::~_BR_CException();
#else
	this->~_BR_CException();	// Virtual dispatch to object's destructor
#endif
	BR_PRIMITIVE_ASSERT(fIsValid==0);
}

//========================================================================================
// Exception classes definition and implementation macros  (Macintosh versions)
//========================================================================================

#ifdef BR_BUILD_MAC

#define _BR_EXCEPTION_DEFINE(name) \
public: \
	_BR_CMetaClass *MyClass() const; \
	_BR_CLASS_DEFINE(name)

#define _BR_EXCEPTION_IMPLEMENT(name, ancestor) \
	_BR_CLASS_IMPLEMENT(name, ancestor) \
	_BR_CMetaClass *name::MyClass() const \
	{ \
		return &__Class; \
	}

#define _BR_EXCEPTION_IMPLEMENT_ROOT(name) \
	_BR_CLASS_IMPLEMENT_ROOT(name) \
	_BR_CMetaClass *name::MyClass() const \
	{ \
		return &__Class; \
	}

#endif

//========================================================================================
// Exception classes definition and implementation macros  (Windows versions)
//========================================================================================

#ifdef BR_BUILD_WIN

#define _BR_EXCEPTION_DEFINE(name) \
public: \
	static _BR_CMetaClass* __StaticGetClass(); \
	_BR_CMetaClass *MyClass() const; \
	_BR_CLASS_DEFINE(name)

#define _BR_EXCEPTION_IMPLEMENT(name, ancestor) \
	_BR_CLASS_IMPLEMENT(name, ancestor) \
	_BR_CMetaClass *name::MyClass() const \
	{ \
		return &__Class; \
	} \
	_BR_CMetaClass* name::__StaticGetClass() \
	{ \
	 	return &__Class; \
	}


#define _BR_EXCEPTION_IMPLEMENT_ROOT(name) \
	_BR_CLASS_IMPLEMENT_ROOT(name) \
	_BR_CMetaClass *name::MyClass() const \
	{ \
		return &name::__Class; \
	} \
	_BR_CMetaClass* name::__StaticGetClass() \
	{ \
	 	return &__Class; \
	}


#endif

#endif
