#if !defined(BRWINPRO_H) && !defined(__BEDRC__)
#define BRWINPRO_H
//========================================================================================
//
//     File:			BRWinPro.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	January 20, 1993
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#if !defined(__INC_WINDOWS)
#include <windows.h>
#endif

#ifndef BRTSTRS_H
#include "BRTStrs.h"
#endif

#ifndef BRVIEW_H
#include "BRView.h"
#endif

//========================================================================================
// Constants
//========================================================================================

#ifdef BR_BUILD_WIN

#define GWL_OBJECT 	0
#define MAXTASKS 	256

#endif

//========================================================================================
// Global variable declarations
//========================================================================================

#ifdef BR_BUILD_WIN

// Default message handling methods

extern FARPROC  fpOldScrollProc;
extern FARPROC  fpOldListBoxProc;
extern FARPROC  fpOldEntryListBoxProc;
extern FARPROC  fpOldButtonProc;
extern FARPROC  fpOldEditProc;
extern FARPROC  fpOldStaticProc;

// Under bcl, a HWND instance is allocated with extra fSpace to hold pointers to cViews
// that are associated with the HWND. These variables contain the offsets in the extra
// fSpace that correspond to a given cView

extern WORD wScrollBytes;
extern WORD wListBoxBytes;
extern WORD wEntryListBoxBytes;
extern WORD wButtonBytes;
extern WORD wEditBytes;
extern WORD wStaticBytes;

extern WORD WM_BEDGETOBJECT;

#endif

//========================================================================================
// Global procedure declarations
//========================================================================================

#ifdef BR_BUILD_WIN

// Window Procedures (procs)

long    FAR PASCAL BCLFrameProc(HWND, WORD, WORD, long);
long    FAR PASCAL BCLChildProc(HWND, WORD, WORD, long);
long    FAR PASCAL BCLPaneProc(HWND, WORD, WORD, long);
long    FAR PASCAL BCLScrollProc(HWND, WORD, WORD, long);
long    FAR PASCAL BCLListBoxProc(HWND, WORD, WORD, long);
long    FAR PASCAL BCLEntryListBoxProc(HWND, WORD, WORD, long);
long    FAR PASCAL BCLButtonProc(HWND, WORD, WORD, long);
long    FAR PASCAL BCLEditProc(HWND, WORD, WORD, long);

HWND    FAR PASCAL GetAppWindow(BR_TString<BR_Char>& Title);
FARPROC FAR PASCAL GetConstructorAddress(char* pClassName, HANDLE hInstance);

#ifdef CCOVER
	// Cannot be inline for code coverage because we split bcl.DLL into several
	BR_CView* GetView(const HWND fHWND);
#else
	inline BR_CView* GetView(const HWND fHWND)
	{
		return ((BR_CView *)::SendMessage(fHWND, WM_BEDGETOBJECT, 0, 0));
	}
#endif

#endif

#endif
