#if !defined(BRWINDOW_H) && !defined(__BEDRC__)
#define BRWINDOW_H
//========================================================================================
//
//     File:			BRWindow.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	August 16, 1990
//
//     COPYRIGHT 1990-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRWINDOW_K
#include "BRWindow.k"
#endif

#ifndef BRVIEW_H
#include "BRView.h"
#endif

#ifndef BRCANVAS_H
#include "BRCanvas.h"
#endif

#if defined(BR_BUILD_MAC) && !defined(__WINDOWS__)
#include <Windows.h>
#endif

#if defined(BR_BUILD_MAC) && !defined(__QUICKDRAW__)
#include <Quickdraw.h>
#endif


//========================================================================================
// Forward declarations
//========================================================================================

class BR_CDialogBox;
class BR_CPushButton;
class BR_CWindowMenu;
class BR_CWindow;

//========================================================================================
// Constants
//========================================================================================

#ifdef BR_BUILD_MAC
const unsigned short kMacResizeBoxSize	= 16;		// size of sizebox in pixels
const short kMacWindowKind	= 9;				// WindowRecord userKind for cWindows
#endif


//========================================================================================
// BR_SWinResource
//========================================================================================

struct BR_SWinResource : BR_SViewResource
{
    char   					fTitle[64];
    BR_CView::ViewStyle 	fWindowStyle;
};

//========================================================================================
// CLASS BR_CWindowCanvas
//========================================================================================

class BR_CWindowCanvas : public BR_CCanvas
{
public:
	BR_CWindowCanvas(BR_CWindow *theWindow);
	virtual 		~BR_CWindowCanvas();
	
	virtual void 	GetDrawArea(BR_CRectangle& area) const;

//----------------------------------------------------------------------------------------
//	Windows
// ---------------------------------------------------------------------------------------
#ifdef BR_BUILD_WIN
public:
	virtual HDC 	BedWinCreateDC(BR_CView& pane);
	virtual void 	BedWinDeleteDC(BR_CView& pane, HDC hDC);
#endif

//----------------------------------------------------------------------------------------
//	Macintosh
//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_MAC
public:
	void 			BedMacSetGrafPort(GrafPtr newMacGrafPort);
	GrafPtr 		BedMacGetGrafPort() const;
	virtual void 	BedMacViewToCanvasOwner(BR_CPoint &aPoint) const;
private:
	GrafPtr			fMacGrafPtr;
#endif

	BR_SETCLASSNAME(BR_CWindowCanvas);
};

#ifdef BR_BUILD_MAC
//------------------------------------------------------------------------
// BR_CWindowCanvas::BedMacSetGrafPort
//------------------------------------------------------------------------
inline void BR_CWindowCanvas::BedMacSetGrafPort(GrafPtr newMacGrafPort)
{
	fMacGrafPtr = newMacGrafPort;
}
#endif

//========================================================================================
// CLASS BR_CWindow
//
// This class is the largest enclosure for panes (not counting the application desktop).
// This class and its subclasses contain the borders, titlebar, and controls normally
// associated with GUI windows.
//========================================================================================

class BR_CWindow : public BR_CView
{
#ifdef BR_BUILD_MAC
	friend class  BR_CMacWindowHelper;
#endif

public:
	BR_CWindow(BR_CView *enclosure,
			   BR_CBureaucrat *supervisor,
			   ViewStyle windowStyle);

	BR_CWindow(BR_CView *enclosure,
			   BR_CBureaucrat *supervisor,
			   const BR_CModule &module,
			   BR_SResource &winRes,
			   BR_Boolean setInterior = TRUE);

	virtual					~BR_CWindow();
	void 						SetMainPane(BR_CView *newPane);
	BR_CView*					GetMainPane() const;
	BR_Boolean 					IsActive() const;
	BR_CPushButton*				GetDefPushButton() const;

	void 						BringToTop();
		// Places this window on fTop of all other windows

	// New virtual methods
	virtual void 				SetDefPushButton(BR_CPushButton *button);
	virtual void 				ButtonActivate(BR_CPushButton *button);
	virtual void 				ButtonDeactivate(BR_CPushButton &button);
	virtual void 				Zoom();
	virtual void 				Restore();
	virtual BR_Boolean 		IsZoomed() const;
	virtual BR_Boolean 		IsRestored() const;

	// Inherited virtual methods
	virtual BR_Boolean 		Close();
	virtual BR_Boolean 		SetFocus();
	virtual void 				ReceiveFocus();
	virtual void 				Show(BR_Boolean show = TRUE);
	virtual void 				Activate();
	virtual void 				Deactivate();
	virtual BR_CViewHelper*	CreateViewHelper();

	virtual BR_CWindow*		GetWindow() const;	
	virtual BR_CDialogBox*		GetDialogBox() const;

	ViewStyle 					GetWStyle() const;
	void 						SetWStyle(ViewStyle windowStyle);
	BR_Boolean 					HasWStyle(ViewStyle windowStyle) const;
	BR_Boolean 					IsResizable() const;
	BR_Boolean 					HasCloseBox() const;
	BR_Boolean 					IsAppModal() const;

protected:
	virtual BR_CCanvas*		BedLookForDrawingCanvas() const;
	virtual BR_CView*			BedGetViewWithCanvas() const;

private:
	BR_CWindowCanvas	*fCanvas;				// the window canvas
	ViewStyle 			fWindowStyle;			// Window Style
	BR_CView 			*fMainPane;				// This instance's main pane
	BR_CPushButton 		*fDefPushButton;		// The default Push button
	BR_CPushButton 		*fActivePushButton;		// The active Push button
	BR_Boolean 			fActive:1;				// TRUE if this instance is active

	// New methods
	void InitWindow(BR_CView *enclosure,
					BR_CBureaucrat *supervisor,
					ViewStyle windowStyle,
					const BR_CRectangle &windowFrame,
					BR_Char* title);
					
//-------------------------------------------------------------------------
//   Macintosh
//-------------------------------------------------------------------------
#ifdef BR_BUILD_MAC
public:
	virtual void BedGetResolutionFactors(ViewUnits inUnit,
										 ViewUnits outUnit,
										 unsigned short &xNum,
										 unsigned short &xDen,
										 unsigned short &yNum,
										 unsigned short &yDen) const;// ?INTERNAL?
	
private:
	BR_Boolean fInUpdate:1;						// TRUE if within BeginUpdate/EndUpdate
#endif

//-------------------------------------------------------------------------
//   Windows
//-------------------------------------------------------------------------
#ifdef BR_BUILD_WIN
public:
	LONG DoDefaultProc(WORD wMessage,
					   WORD wParam,
					   LONG lParam);			// ?INTERNAL?


protected:
	BR_CWindow(BR_CAppDesktop *enclosure,
			   BR_CBureaucrat *super);			// ?INTERNAL?

	virtual BR_CView*		GetLastViewWithFocus() const;	// ?INTERNAL?
	virtual void 			SetLastViewWithFocus(BR_CView *theView);// ?INTERNAL?

private:
	void FixSystemMenu();						// ?INTERNAL?

	BR_CView *fLastViewWithFocus;				// Used for view validation

#endif

	BR_SETCLASSNAME(BR_CWindow);
};

//------------------------------------------------------------------------
// BR_CWindow::GetMainPane
//------------------------------------------------------------------------
inline BR_CView *BR_CWindow::GetMainPane() const
{
	return fMainPane;
}

//------------------------------------------------------------------------
// BR_CWindow::IsActive
//------------------------------------------------------------------------
inline BR_Boolean BR_CWindow::IsActive() const
{
	return fActive;
}

//------------------------------------------------------------------------
// BR_CWindow::GetDefPushButton
//------------------------------------------------------------------------
inline BR_CPushButton *BR_CWindow::GetDefPushButton() const
{
	return fActivePushButton;
}

//------------------------------------------------------------------------
// BR_CWindow::IsResizable
//------------------------------------------------------------------------
inline BR_Boolean BR_CWindow::IsResizable()  const
{
	return (fWindowStyle & kResizeable) != 0;
}

//------------------------------------------------------------------------
// BR_CWindow::HasCloseBox
//------------------------------------------------------------------------
inline BR_Boolean BR_CWindow::HasCloseBox() const
{
	return (fWindowStyle & kHasCloseBox) != 0;
}
	
//------------------------------------------------------------------------
// BR_CWindow::BringToTop
//------------------------------------------------------------------------
inline void BR_CWindow::BringToTop()
{
#ifdef BR_BUILD_MAC
    ::SelectWindow(GetPlatformWindow());
#endif
#ifdef BR_BUILD_WIN
    ::BringWindowToTop(GetPlatformWindow());
#endif
}

//------------------------------------------------------------------------
// BR_CWindow::IsAppModal
//------------------------------------------------------------------------
inline BR_Boolean BR_CWindow::IsAppModal() const
{
	return (fWindowStyle & kModalDialog) != 0;
}

//------------------------------------------------------------------------
// BR_CWindow::HasWStyle
//------------------------------------------------------------------------
inline BR_Boolean BR_CWindow::HasWStyle(ViewStyle windowStyle) const
{
	return (fWindowStyle & windowStyle) != 0;
}

//------------------------------------------------------------------------
// BR_CWindow::GetWStyle
//------------------------------------------------------------------------
inline BR_CView::ViewStyle BR_CWindow::GetWStyle() const
{
	return fWindowStyle;
}


#endif
