#if !defined(BRWALLPA_H) && !defined(__BEDRC__)
#define BRWALLPA_H
//========================================================================================
//
//     File:			BRWallpa.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	October 19, 1990
//
//     COPYRIGHT 1990-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRGRAPHT_H
#include "BRGraphT.h"
#endif

#ifndef BRCOLOR_H
#include "BRColor.h"
#endif

#ifndef BRGRVLA_H
#include "BRGrVLa.h"
#endif

#ifndef BRGRCOMM_H
#include "BRGrComm.h"
#endif

#if defined(BR_BUILD_MAC) && !defined(__QUICKDRAW__)
#include <QuickDraw.h>
#endif

//========================================================================================
//	Forward class declaration
//========================================================================================
class BR_CBitmap;
class BR_CView;

//========================================================================================
//	BR_CWallPaper
//========================================================================================
class BR_CWallPaper : public BR_CGraphicsTool
{
	friend BR_CGraphicsToolSelector;
	friend BR_CCanvas;

public:
	BR_CWallPaper(const BR_CColor& color);
	BR_CWallPaper(BR_CBitmap& bitmap);
	BR_CWallPaper(BR_Pattern wallPattern,
				  const BR_CColor& hatchColor,
				  const BR_CColor& fillColor);

	virtual~ BR_CWallPaper();

	// Used to reset the origin of the wallpaper brush after an RGB_
	// macro has been used to specify a color.  Unrealize() should not be
	// called if the wallpaper is created with a stock color.
	void Unrealize();

	// Use the fNext four methods to find out wallpaper attributes

	BR_Boolean IsBitmapWallPaper() const;
	// If TRUE, results of the three methods below are undefined.

	BR_CColor GetFillColor() const;
	BR_CColor GetHatchColor() const;
	BR_Pattern GetPattern() const;

	void SetHatchColor(const BR_CColor& newHatchColor);
	void SetFillColor(const BR_CColor& newFillColor);
	void SetPattern(BR_Pattern newPattern);

	void Set(BR_Pattern pattern,
			 const BR_CColor& hatchColor,
			 const BR_CColor& fillColor);

	const BR_CBedWallPaper* BedGetWallPaper() const;		// ?INTERNAL?
	BR_Boolean IsTransparent() const;			// ?INTERNAL?

protected:
	virtual BR_CGraphicsTool* GetCurrentTool(const BR_CCanvas& canvas) const;
	virtual void SetCurrentTool(BR_CCanvas& canvas,
								   BR_CGraphicsTool* graphicsTool) const;
	virtual void SetupTool(BR_CView& pane,
						   GraphicsToolSelectionOptions selectionOptions,
						   BR_SGraphicsToolSuspendResumeState* state);
	virtual void RestoreNullTool(BR_CView& pane);

	BR_CWallPaper(const BR_CBedDeferredTool& deferred);
	virtual void OnAttributeChange();
	void Create();
	void Dispose();

	void Set(BR_Pattern pattern,
			 const BR_CColor& hatchColor,
			 const BR_CColor& fillColor,
			 BR_Boolean fromCtor);

private:
	BR_Boolean fIsBitmapWallpaper:1;

	BR_CBedWallPaper fBedWallPaper;				// Most of the data resides here

	//----------------------------------------------------------------------------------------
	// Macintosh
	//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_MAC
public:
	void BedMacPrepareOp() const;
	static void BedMacPrepareNullOp();
#endif

	//----------------------------------------------------------------------------------------
	// Windows
	//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_WIN
public:
	HANDLE GetHandle() const;
#endif

	BR_SETCLASSNAME(BR_CWallPaper);
};

//----------------------------------------------------------------------------------------
// Macintosh
//----------------------------------------------------------------------------------------
inline BR_CColor BR_CWallPaper::GetFillColor() const
{
	return fBedWallPaper.GetFillColor();
}

//----------------------------------------------------------------------------------------
// Macintosh
//----------------------------------------------------------------------------------------
inline BR_CColor BR_CWallPaper::GetHatchColor() const
{
	return fBedWallPaper.GetHatchColor();
}

//----------------------------------------------------------------------------------------
// BR_CWallPaper::GetPattern
//----------------------------------------------------------------------------------------
inline BR_Pattern BR_CWallPaper::GetPattern() const
{
	return fBedWallPaper.GetPattern();
}

//----------------------------------------------------------------------------------------
// BR_CWallPaper::IsBitmapWallPaper
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CWallPaper::IsBitmapWallPaper() const
{
	return fIsBitmapWallpaper;
}

//----------------------------------------------------------------------------------------
// BR_CWallPaper::Unrealize
//----------------------------------------------------------------------------------------
inline void BR_CWallPaper::Unrealize()
{
#ifdef BR_BUILD_WIN
	// ?KVV: On the Mac, we set wallPaper origin in BR_CCanvas::BaseOpenPane.  Windows -- ???
	::UnrealizeObject(fBedWallPaper.WinGetHandle());
#endif

}

//----------------------------------------------------------------------------------------
// BR_CWallPaper::BedGetWallPaper
//----------------------------------------------------------------------------------------
inline const BR_CBedWallPaper* BR_CWallPaper::BedGetWallPaper() const
{
	return &fBedWallPaper;
}

//----------------------------------------------------------------------------------------
// BR_CWallPaper::IsTransparent
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CWallPaper::IsTransparent() const
{
	return fBedWallPaper.GetHatchColor().IsTransparent();
}


#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
// BR_CWallPaper::GetHandle
//----------------------------------------------------------------------------------------
inline HANDLE BR_CWallPaper::GetHandle() const
{
	return fBedWallPaper.WinGetHandle();
}
#endif

//========================================================================================
// CLASS BR_CDeferredWallPaper
//
// A wallpaper that doesn't use system resources when it's not selected
//========================================================================================

class BR_CDeferredWallPaper : public BR_CWallPaper
{
public:
	BR_CDeferredWallPaper(const BR_CColor& newColor);
	virtual~ BR_CDeferredWallPaper();

protected:
	virtual void SetupTool(BR_CView& pane,
						   GraphicsToolSelectionOptions selectionOptions,
						   BR_SGraphicsToolSuspendResumeState* state);
	virtual void Unselect(BR_CView& Pane,
						  GraphicsToolSelectionOptions selectionOptions,
						  BR_SGraphicsToolSuspendResumeState* state);
	virtual void OnAttributeChange();

	BR_SETCLASSNAME(BR_CDeferredWallPaper);
};

#endif


