#if !defined(BRTXTSEL_H) && !defined(__BEDRC__)
#define BRTXTSEL_H
//========================================================================================
//
//     File:		BRTxtSel.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	11/9/90
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   BRMOUSEA_H
#include "BRMouseA.h"
#endif

#ifndef BRSTATXT_H
#include "BRStaTxt.h"
#endif

//========================================================================================
//	Forward class declarations
//========================================================================================

class BR_CSelectText;


//========================================================================================
//	BR_CTextSelection
//========================================================================================

class BR_CTextSelection : public BR_CMouseAction
{
public:
	BR_CTextSelection(BR_CSelectText& selectText);
	BR_CTextSelection(BR_CSelectText& selectText,
					  BR_CStaticText::LineNumber anchorLine,
					  BR_CStaticText::ColumnNumber anchorColumn,
					  BR_CStaticText::LineNumber dragLine,
					  BR_CStaticText::ColumnNumber dragColumn);

	virtual~ BR_CTextSelection();

	// New instances of inherited virtual methods
	virtual void KeepTracking(const BR_CPoint& currentPoint);
	virtual void EndTracking(const BR_CPoint& currentPoint);
	virtual BR_Boolean Undo();
	virtual BR_Boolean Do();

	// New virtual methods
	virtual BR_Boolean Extend(const BR_CPoint& extentPoint);
	virtual BR_Boolean IsEmpty() const;

	void GetLinesAndColumns(BR_CStaticText::LineNumber& startingLine,
							BR_CStaticText::ColumnNumber& startingColumn,
							BR_CStaticText::LineNumber& endingLine,
							BR_CStaticText::ColumnNumber& endingColumn) const;

protected:
	virtual BR_Boolean DoTextHilite(BR_CStaticText::LineNumber startingLine,
									BR_CStaticText::ColumnNumber startingColumn,
									BR_CStaticText::LineNumber endingLine,
									BR_CStaticText::ColumnNumber endingColumn);
	void GetAnchorPosition(BR_CStaticText::LineNumber& anchorLine,
						   BR_CStaticText::ColumnNumber& anchorColumn) const;
	virtual void SetAnchorPosition(BR_CStaticText::LineNumber anchorLine,
								   BR_CStaticText::ColumnNumber anchorColumn);
	void GetDragPosition(BR_CStaticText::LineNumber& dragLine,
						 BR_CStaticText::ColumnNumber& dragColumn) const;
	virtual void SetDragPosition(BR_CStaticText::LineNumber dragLine,
								 BR_CStaticText::ColumnNumber dragColumn);
	void GetPositionsInOrder(BR_CStaticText::LineNumber& lineNumber1,
							 BR_CStaticText::ColumnNumber& columnNumber1,
							 BR_CStaticText::LineNumber& lineNumber2,
							 BR_CStaticText::ColumnNumber& columnNumber2) const;
	BR_CSelectText* GetSelectText() const;

private:
	BR_CStaticText::LineNumber fAnchorLine;
	BR_CStaticText::ColumnNumber fAnchorColumn;
	BR_CStaticText::LineNumber fDragLine;
	BR_CStaticText::ColumnNumber fDragColumn;

	void InitTextSelection(BR_CSelectText& selectText,
						   BR_CStaticText::LineNumber anchorLine,
						   BR_CStaticText::ColumnNumber anchorColumn,
						   BR_CStaticText::LineNumber dragLine,
						   BR_CStaticText::ColumnNumber dragColumn);

	BR_SETCLASSNAME(BR_CTextSelection);
};

#endif
