#if !defined(BRTRICHK_H) && !defined(__BEDRC__)
#define BRTRICHK_H
//========================================================================================
//
//     File:			BRTriChk.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	March 27, 1993
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRSUPDEF_H
#include "BRSupDef.h"
#endif

#ifndef BRBUTTON_H
#include "BRButton.h"
#endif

#if defined(BR_BUILD_MAC) && !defined(BRMOUSEA_H)
#include "BRMouseA.h"
#endif

#if defined(BR_BUILD_MAC) && !defined(BRGRHELP_H)
#include "BRGrHelp.h"
#endif

//----------------------------------------------------------------------------------------
// STRUCT BR_STriCheckBoxResource
//----------------------------------------------------------------------------------------

struct BR_STriCheckBoxResource : BR_SCheckedButtonResource
{
};

//========================================================================================
//	CLASS BR_CTriStateCheckBox
//========================================================================================

class BR_CTriStateCheckBox : public BR_CCheckedButton
{
#ifdef BR_BUILD_MAC
	friend class BR_CTrackTriCheckBox;
#endif

public:
	typedef short int TriCheckState;
	enum TriCheckStateConstants { kOff = 0, kOn = 1, kNull = 2 };

public:
	BR_CTriStateCheckBox(BR_CView* enclosure,
				 		BR_CBureaucrat* supervisor,
				 		BR_Distance width,
				 		BR_Distance height,
				 		BR_Coordinate x,
				 		BR_Coordinate y,
				 		ViewSizing horizontalSizing,
				 		ViewSizing verticalSizing,
				 		ViewId viewId,
				 		const BR_TString<BR_Char>& text,
				 		BR_Boolean automatic = TRUE);

	BR_CTriStateCheckBox(BR_CView* enclosure,
				 		BR_CBureaucrat* supervisor,
				 		const BR_CModule& module,
				 		BR_SResource& resource);

	virtual~ BR_CTriStateCheckBox();

	TriCheckState GetTriState() const;
	virtual void SetTriState(TriCheckState newState);

#ifdef BR_BUILD_MAC
public:
	virtual BR_Boolean IsChecked() const;
	virtual void 		Check(BR_Boolean checked = TRUE);
	virtual void 		Uncheck();
	virtual void 		Draw(BR_CCanvas &canvas, const BR_CRectangle& area);
	virtual void 		DoClick(const BR_CPoint& point, KeyModifiers keyFlags);

	
protected:
	void 				CalcCheckBox(BR_CRectangle &box);
	void 				BedMacHilite(BR_Boolean state);
	BR_Boolean 			BedMacIsHilited() const;
	void 				BedMacDrawCheck();
	void 				BedMacToggleCheck();

private:
	TriCheckState fCurrentState;
	BR_Boolean fHiliteState;
#endif

	BR_SETCLASSNAME(BR_CTriStateCheckBox);
};

#ifdef BR_BUILD_MAC
//---------------------------------------------------------------------------
//	BR_CTriStateCheckBox::BedMacIsHilited()
//---------------------------------------------------------------------------

inline BR_Boolean BR_CTriStateCheckBox::BedMacIsHilited() const
{
	return fHiliteState;
}
#endif


#ifdef BR_BUILD_MAC
//========================================================================================
//	CLASS BR_CTrackTriCheckBox
//========================================================================================

class BR_CTrackTriCheckBox : public BR_CMouseAction
{
public:
	BR_CTrackTriCheckBox(BR_CTriStateCheckBox* originator);
	virtual~ BR_CTrackTriCheckBox();

	virtual void KeepTracking(const BR_CPoint& currentPoint);
	virtual void EndTracking(const BR_CPoint& currentPoint);

	BR_CTriStateCheckBox* GetTriStateCheckBox() const;

private:
	BR_CDrawInitiator fDrawInitiator;
		// We keep the checkbox in drawing state while tracking

	BR_SETCLASSNAME(BR_CTrackTriCheckBox);
};
#endif

#ifdef BR_BUILD_MAC
//---------------------------------------------------------------------------
//	BR_CTriStateCheckBox::GetTriStateCheckBox
//---------------------------------------------------------------------------

inline BR_CTriStateCheckBox* BR_CTrackTriCheckBox::GetTriStateCheckBox() const
{
	return (BR_CTriStateCheckBox*)GetPane();
}
#endif

#endif
