#if !defined(BRSYSTEM_H) && !defined(__BEDRC__)
#define BRSYSTEM_H
//========================================================================================
//
//     File:			BRSystem.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	12/08/90
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRSYSTEM_K
#include "BRSystem.k"
#endif

#ifndef BRMODULE_H
#include "BRModule.h"
#endif

#ifndef BRRECT_H
#include "BRRect.h"
#endif

#ifndef BCCOLL_H
#include "BCColl.c"
#endif

#ifndef BRCOLOR_H
#include "BRColor.h"
#endif

#ifndef BRFONT_H
#include "BRFont.h"
#endif

#ifdef BR_BUILD_MAC

#ifndef __TOOLUTILS__
#include <ToolUtils.h>
#endif

#ifndef __OSUTILS__
#include <OSUtils.h>
#endif

#ifndef __EVENTS__
#include <Events.h>
#endif

#endif

//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CFontList;
class BR_CPullDownMenu;
class BR_CFont;


//========================================================================================
//	BR_CSystem
//========================================================================================

class BR_CSystem : public BR_CModule
{
public:
	typedef int SystemColor;
	enum SystemColorConstants
	{
		kWindow = COLOR_WINDOW, kWindowText = COLOR_WINDOWTEXT, kApplicationWorkSpace = COLOR_APPWORKSPACE, kButtonFace = COLOR_BTNFACE, kButtonText = COLOR_BTNTEXT, kHighlight = COLOR_HIGHLIGHT, kHighlightText = COLOR_HIGHLIGHTTEXT
	};


	BR_CSystem();
	BR_CSystem(BR_CSystem* supervisor);
	BR_CSystem(BR_PlatformHandle instanceHandle);// Internal ???
	virtual~ BR_CSystem();
	static void DoBeep();
	static BR_CColor::RGBValue GetRGBSysColor(const SystemColor systemColor);// Internal ???
	static BR_CColor GetSysColor(SystemColor systemColor);
	virtual BR_CCursor* GetCursor(BR_ResourceId resourceId) const;
	virtual BR_CFont* GetSystemFont() const;
	virtual BR_CSystem* GetSystem() const;
	virtual BR_CObject* CreateObjectFromResource(BR_CObjectResource& objectResource,
												 BR_Boolean callSupervisor = TRUE) const;
	virtual BR_CObject* CreateObjectByName(const BR_TString<BR_Char>& className,
										   BR_Boolean callSupervisor = TRUE) const;
	unsigned short FillFontMenu(BR_CPullDownMenu& pullDownMenu);
	unsigned short FillFontList(BR_CFontList& fontList);
	static unsigned short FillFontSizeList(BC_TCollection<long> &fontSizeList,
										   BR_CFont::FontId fFontId);
	static unsigned short FillFontSizeList(BC_TCollection<long> &fontSizeList,
										   BR_CModule& module,
										   BR_ResourceId fontNameResourceId);
	static unsigned short FillFontSizeList(BC_TCollection<long> &fontSizeList,
										   BR_TString<BR_Char>& strFontName);
	static BR_Boolean IsMousePresent();
	static void HideMouse();
	static void ShowMouse();
	static void GetMousePos(BR_CPoint& mousePosition);
	static void SetMousePos(BR_CPoint mousePosition);
	static BR_Boolean IsControlDown();
	static BR_Boolean IsKeyDown(Key theKey);
	static BR_Boolean IsShiftDown();
	static BR_Boolean IsValidDrive(const BR_TString<BR_Char>& driveName);
	static BR_Boolean IsValidDirectory(const BR_TString<BR_Char>& directoryName);
	static BR_Boolean GetCurrentDirectory(BR_TString<BR_Char>& directoryName);
	static BR_Boolean GetCurrentDrive(BR_TString<BR_Char>& driveName);
	static BR_Boolean SetCurrentDirectory(const BR_TString<BR_Char>& directoryName);
	static BR_Boolean SetCurrentDrive(const BR_TString<BR_Char>& driveName);
	static void GetScreenResolution(BR_CPoint& screenResolution);
	static void GetThousandsSeparator(BR_TString<BR_Char>& strBuffer);
	static void GetDecimal(BR_TString<BR_Char>& strBuffer);
	static BR_CPoint GetDefaultScrollBarThicknessInPixels();

private:
	static void GetInternationalInfo(Key thekey,
									 BR_TString<BR_Char>& strBuffer);


#ifdef BR_BUILD_MAC
public:
	static short GetEnvironsVersion();
	static short GetMachineType();
	static short GetSystemVersion();
	static short GetProcessorType();
	static BR_Boolean HasFPU();
	static BR_Boolean HasColorQD();
	static BR_Boolean HasDeepGWorlds();
	static BR_Boolean HasDirectPixMaps();
	static BR_Boolean HasGrayishTextOr();
	static BR_Boolean Has32BitQD();
	static short GetKeyboardType();
	static long GetTEVersion();
	static BR_Boolean HasROM128KOrBetter();
	static BR_Boolean HasHFS();
	static BR_Boolean HasHierarchicalMenus();
	static BR_Boolean HasStyleTextEdit();
	static BR_Boolean HasSoundManager();
	static BR_Boolean HasWaitNextEvent();
	static BR_Boolean HasSCSI();
	static BR_Boolean HasDesktopBus();
	static BR_Boolean HasAUX();
	static BR_Boolean HasScriptManager();
	static BR_Boolean HasTempMem();
	static BR_Boolean HasAppleEventMgr();
	static BR_Boolean HasEditionMgr();
	static BR_Boolean HasHelpMgr();
	static BR_Boolean HasAliasMgr();
	static BR_Boolean HasFindFolder();
	static BR_Boolean HasProcessMgr();
	static BR_Boolean HasPopupCDEF();
	static BR_Boolean HasTrueType();
	static BR_Boolean HasStandardFile58();
	static void FlushCache();
	static BR_Boolean TrapExists(short theTrap);
	static TrapType GetTrapType(short theTrap);
	static short NumToolboxTraps();
	static BR_Boolean HasGestaltAttr(OSType itsAttr,
									 unsigned short itsBit);
	static long GetGestaltResult(OSType itsAttr);
	static short GetFSFCBLen();
	static short GetHardwareConfigurationFlags();

private:
	static short gMacEnvironsVersion;
	static short gMacMachineType;
	static BR_Boolean gMacHasROM128KOrBetter;
	static BR_Boolean gMacHasHFS;
	static short gMacSystemVersion;
	static short gMacProcessor;
	static BR_Boolean gMacHasFPU;
	static BR_Boolean gMacHasColorQD;
	static BR_Boolean gMacHasDeepGWorlds;
	static BR_Boolean gMacHasDirectPixMaps;
	static BR_Boolean gMacHasGrayishTextOr;
	static BR_Boolean gMacHas32BitQD;
	static short gMacKeyboardType;
	static BR_Boolean gMacHasSCSI;
	static BR_Boolean gMacHasAUX;
	static BR_Boolean gMacHasScriptManager;
	static BR_Boolean gMacHasTempMem;
	static long gMacTEVersion;
	static BR_Boolean gMacHasDesktopBus;
	static BR_Boolean gMacHasHierarchicalMenus;
	static BR_Boolean gMacHasStyleTextEdit;
	static BR_Boolean gMacHasSoundManager;
	static BR_Boolean gMacHasWaitNextEvent;
	static BR_Boolean gMacHasAppleEventMgr;
	static BR_Boolean gMacHasEditionMgr;
	static BR_Boolean gMacHasHelpMgr;
	static BR_Boolean gMacHasAliasMgr;
	static BR_Boolean gMacHasFindFolder;
	static BR_Boolean gMacHasProcessMgr;
	static BR_Boolean gMacHasPopupCDEF;
	static BR_Boolean gMacHasTrueType;
	static BR_Boolean gMacHasStandardFile58;
#endif


#ifdef BR_BUILD_WIN
public:
	static int GetMetrics(int iIndex);
	static short EnumFonts(BR_Boolean enumPrinterFonts,
						   BR_Char* fontName,
						   FARPROC callbackProc,
						   void* data);
#endif

	BR_SETCLASSNAME(BR_CSystem);
};


#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::GetEnvironsVersion
//----------------------------------------------------------------------------------------

static inline short BR_CSystem::GetEnvironsVersion()
{
	return gMacEnvironsVersion;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::GetMachineType
//----------------------------------------------------------------------------------------

static inline short BR_CSystem::GetMachineType()
{
	return gMacMachineType;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::GetSystemVersion
//----------------------------------------------------------------------------------------

static inline short BR_CSystem::GetSystemVersion()
{
	return gMacSystemVersion;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::GetProcessorType
//----------------------------------------------------------------------------------------

static inline short BR_CSystem::GetProcessorType()
{
	return gMacProcessor;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::HasFPU
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::HasFPU()
{
	return gMacHasFPU;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::HasColorQD
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::HasColorQD()
{
	return gMacHasColorQD;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::HasDeepGWorlds
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::HasDeepGWorlds()
{
	return gMacHasDeepGWorlds;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::HasDirectPixMaps
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::HasDirectPixMaps()
{
	return gMacHasDirectPixMaps;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::HasGrayishTextOr
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::HasGrayishTextOr()
{
	return gMacHasGrayishTextOr;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::Has32BitQD
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::Has32BitQD()
{
	return gMacHas32BitQD;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::GetKeyboardType
//----------------------------------------------------------------------------------------

static inline short BR_CSystem::GetKeyboardType()
{
	return gMacKeyboardType;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::GetTEVersion
//----------------------------------------------------------------------------------------

static inline long BR_CSystem::GetTEVersion()
{
	return gMacTEVersion;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::HasROM128KOrBetter
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::HasROM128KOrBetter()
{
	return gMacHasROM128KOrBetter;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::HasHFS
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::HasHFS()
{
	return gMacHasHFS;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::HasHierarchicalMenus
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::HasHierarchicalMenus()
{
	return gMacHasHierarchicalMenus;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::HasStyleTextEdit
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::HasStyleTextEdit()
{
	return gMacHasStyleTextEdit;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::HasSoundManager
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::HasSoundManager()
{
	return gMacHasSoundManager;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::HasWaitNextEvent
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::HasWaitNextEvent()
{
	return gMacHasWaitNextEvent;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::HasSCSI
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::HasSCSI()
{
	return gMacHasSCSI;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::HasDesktopBus
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::HasDesktopBus()
{
	return gMacHasDesktopBus;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::HasAUX
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::HasAUX()
{
	return gMacHasAUX;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::HasScriptManager
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::HasScriptManager()
{
	return gMacHasScriptManager;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::HasTempMem
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::HasTempMem()
{
	return gMacHasTempMem;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::HasAppleEventMgr
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::HasAppleEventMgr()
{
	return gMacHasAppleEventMgr;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::HasEditionMgr
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::HasEditionMgr()
{
	return gMacHasEditionMgr;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::HasHelpMgr
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::HasHelpMgr()
{
	return gMacHasHelpMgr;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::HasAliasMgr
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::HasAliasMgr()
{
	return gMacHasAliasMgr;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::HasFindFolder
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::HasFindFolder()
{
	return gMacHasFindFolder;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::HasProcessMgr
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::HasProcessMgr()
{
	return gMacHasProcessMgr;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::HasPopupCDEF
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::HasPopupCDEF()
{
	return gMacHasPopupCDEF;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::HasTrueType
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::HasTrueType()
{
	return gMacHasTrueType;
}
#endif


#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CSystem::HasStandardFile58
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::HasStandardFile58()
{
	return gMacHasStandardFile58;
}
#endif

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
// BR_CSystem::GetMetrics
//----------------------------------------------------------------------------------------

static inline int BR_CSystem::GetMetrics(int iIndex)
{
	return (::GetSystemMetrics(iIndex));
}
#endif

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
// BR_CSystem::GetRGBSysColor
//----------------------------------------------------------------------------------------

static inline BR_CColor::RGBValue BR_CSystem::GetRGBSysColor(const SystemColor systemColor)
{
	return ::GetSysColor(systemColor);
}
#endif

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
// BR_CSystem::IsMousePresent
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::IsMousePresent()
{
	return (::GetSystemMetrics(SM_MOUSEPRESENT));
}
#endif

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
// BR_CSystem::HideMouse
//----------------------------------------------------------------------------------------

static inline void BR_CSystem::HideMouse()
{
	::ShowCursor(FALSE);
}
#endif

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
// BR_CSystem::ShowMouse
//----------------------------------------------------------------------------------------

static inline void BR_CSystem::ShowMouse()
{
	::ShowCursor(TRUE);
}
#endif

//----------------------------------------------------------------------------------------
// BR_CSystem::GetMousePos
//----------------------------------------------------------------------------------------

static inline void BR_CSystem::GetMousePos(BR_CPoint& ptMousePos)
{
#ifdef BR_BUILD_WIN
	POINT thePoint;
	::GetCursorPos(&thePoint);
#endif

#ifdef BR_BUILD_MAC
	Point thePoint;
	::GetMouse(&thePoint);
	::LocalToGlobal(&thePoint);
#endif

	ptMousePos = thePoint;
}

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
// BR_CSystem::SetMousePos
//----------------------------------------------------------------------------------------

static inline void BR_CSystem::SetMousePos(BR_CPoint ptMousePos)
{
	::SetCursorPos(int(ptMousePos. fX), int(ptMousePos. fY));
}
#endif

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
// BR_CSystem::IsKeyDown
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::IsKeyDown(Key theKey)
{
	return (::GetKeyState(theKey) >> 15);
}
#endif

//----------------------------------------------------------------------------------------
// BR_CSystem::IsShiftDown
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::IsShiftDown()
{
#ifdef BR_BUILD_MAC
	return (IsKeyDown(0x38));
#endif

#ifdef BR_BUILD_WIN
	return (IsKeyDown(VK_SHIFT));
#endif

}

//----------------------------------------------------------------------------------------
// BR_CSystem::IsControlDown
//----------------------------------------------------------------------------------------

static inline BR_Boolean BR_CSystem::IsControlDown()
{
#ifdef BR_BUILD_MAC
	return (IsKeyDown(0x3B));					// ???
#endif

#ifdef BR_BUILD_WIN
	return (IsKeyDown(VK_CONTROL));
#endif

}

//----------------------------------------------------------------------------------------
// BR_CSystem::GetSysColor
//----------------------------------------------------------------------------------------

static inline BR_CColor BR_CSystem::GetSysColor(SystemColor systemColor)
{
	return BR_CColor(GetRGBSysColor(systemColor));
}

#endif
