#ifndef BRSTRIDS_H
#define BRSTRIDS_H

//========================================================================================
//
//     File:			BRStrIds.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	1/20/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

//========================================================================================
// Multistring list resource Ids
//========================================================================================

#define IDSL_DEFAULT            0xFFFF
#define IDSL_SHARED             500
#define IDSL_USER               1000
#define IDSL_FONT               IDSL_SHARED

#define IDSL_PRINTERRORS        1
#define IDSL_WINCLASSES         2
#define IDSL_INTERNATIONAL      3
#define IDSL_SFP                4
#define IDSL_SYSTEMMENU         5
#ifdef BR_BUILD_WIN
#define IDSL_DEFAULTFILTER		6		// The id of the default file filter list.
#endif


//========================================================================================
// Multistring list string Ids
//========================================================================================

#define IDS_APPTITLE            1       // The application title
#define IDS_WINDOWMENU          2       // The window menu
#define IDS_HELPMENU            3       // The help menu
#define IDS_HELPFILE            4       // The help file's base filename
#define IDS_STATUSSTRINGHELP    5       // The help status string resource id
#define IDS_MENUIDTOHELPID      6       // The menu id to help id resource id
#define IDS_HELPCURSOR          7       // The id of the help cursor
#define IDS_HELPACCELERATORS    8       // The id of the help accelerator table
#define IDS_USER                100

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
// Windows Class Names
//----------------------------------------------------------------------------------------

#define IDS_CHILDCLASS              101
#define IDS_PANECLASS               102
#define IDS_SCROLLBARCLASS          104
#define IDS_LISTBOXCLASS            105
#define IDS_BUTTONCLASS             106
#define IDS_OLDSCROLLBARCLASS       109
#define IDS_OLDLISTBOXCLASS         110
#define IDS_OLDBUTTONCLASS          111
#define IDS_ENTRYLISTBOXCLASS       115
#define IDS_OLDENTRYLISTBOXCLASS    116
#define IDS_EDITCLASS               117
#define IDS_OLDEDITCLASS            118
#define IDS_POPUPCLASS              119
#define IDS_CLIENTCLASS             120
#define IDS_PARENTCLASS             134
#endif

#define IDS_FRAMECLASS              100
#define IDS_CLIPBOARDTITLE          113
#define IDS_CLIPBOARD               114 // Name of the clipboard program

//----------------------------------------------------------------------------------------
// Generic string ids
//----------------------------------------------------------------------------------------

#define IDS_SYSFONTNAME             121 // System font name
#define IDS_DEFDOCNAME              122 // Default document name
#define IDS_SAVEFILEPROMPT			123 // Default prompt for SaveFile dialog.
#define IDS_CONFIRMCLOSE            125 // Printed when confirming a close
#define IDS_CONFIRMREVERT           126 // Printed When confirming a revert
#define IDS_UNDOSTRING				127 // Text for Undo command
#define IDS_REDOSTRING				128 // Text for Redo command

//----------------------------------------------------------------------------------------
//  Printer messages
//----------------------------------------------------------------------------------------

#define IDS_PRERROR                 100 // Printed when a printer fError occurs
#define IDS_PRABORT                 101 // Printed when printing is Aborted
#define IDS_NODISK                  102 // Not enough disk fSpace to print
#define IDS_NOMEM                   103 // Not enough fMemory to print
#define IDS_DRV                     104 // '.DRV'
#define IDS_NOSUCHPRINTER           105 // Specified printer does not exist
#define IDS_NODEFPRINTER            106 // No default system printer exists

#define IDS_PRINTINGPAGE            107 // Text for printing dialog
#define IDS_PRINTINGDOC             108 // Text for printing dialog
#define IDS_PRINTINGPRINTER         109 // Text for printing dialog
#define IDS_PRINTINGCANCEL			110	// Text for printing dialog cancel
#define IDS_DOCUMENTSETUPTITLE		111	// Title of (Mac) document setup button

#define IDS_PRINT_ERROR				130
#define IDS_PRINT_USERCANCEL		131
#define IDS_PRINT_SPOOLERROR		132
#define IDS_PRINT_OUTOFMEMORY		133
#define IDS_PRINT_OUTOFDISKSPACE	134
#define IDS_PRINT_NOPRINTER			135
#define IDS_PRINT_NOPAGES			136
#define IDS_PRINT_MARGINS2BIG		137
#define IDS_PRINT_PRINTERRORN		138
#define IDS_PRINT_PRINTERRORU		139
#define IDS_PRINT_GENERRORN			140
#define IDS_PRINT_GENERRORU			141

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
//  System menu string ids (MULTISTRING resource: IDSL_SYSTEMMENU)
//----------------------------------------------------------------------------------------

#define IDS_RESTORE                 100 // Restore  menu item
#define IDS_MOVE                    101 // Move     menu item
#define IDS_SIZE                    102 // Size     menu item
#define IDS_MINIMIZE                103 // Minimize menu item
#define IDS_MAXIMIZE                104 // Maximize menu item
#define IDS_CLOSE                   105 // Close    menu item
#endif

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
//  International strings
//----------------------------------------------------------------------------------------

#define IDS_TOPIC                   100
#define IDS_THOUSANDS               101
#define IDS_DECIMAL                 102
#endif

#endif
