#if !defined(BRSLTEXT_H) && !defined(__BEDRC__)
#define BRSLTEXT_H
//========================================================================================
//
//     File:			BRSlText.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	12/20/91
//
//     COPYRIGHT 1991-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   BRSTATXT_H
#include "BRStaTxt.h"
#endif

#ifndef   BRTXTSEL_H
#include "BRTxtSel.h"
#endif

//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CCaret;

//========================================================================================
//	CLASS BR_CSelectText
//========================================================================================

class BR_CSelectText : public BR_CStaticText
{
	friend class BR_CAcquireSelectTextLock;

public:
	BR_CSelectText(BR_CView* enclosure,
				   BR_CBureaucrat* supervisor,
				   BR_Distance width,
				   BR_Distance height,
				   BR_Coordinate fX,
				   BR_Coordinate fY,
				   ViewSizing horizontalSizing,
				   ViewSizing verticalSizing,
				   ViewUnits viewUnits,
				   const BR_CRectangle& interior);

	BR_CSelectText(BR_CView* enclosure,
				   BR_CBureaucrat* supervisor,
				   const BR_CModule& resourceModule,
				   BR_SResource& viewResource);

	virtual ~BR_CSelectText();

	// Inherited virtual methods
	virtual void UpdateMenus(BR_CMenuBar& theMenuBar,
							 BR_Boolean callSupervisor = TRUE);
	virtual BR_Boolean DoCommand(CommandId itsCommandId,
								 BR_CObject* itsNotifier,
								 BR_Boolean callSupervisor = TRUE);
	virtual void ReceiveFocus();
	virtual void LoseFocus(BR_CView *viewReceivingFocus);
	virtual void DoClick(const BR_CPoint &aPoint,
						 KeyModifiers keyFlags);
	virtual void DoMouseUp(const BR_CPoint &aPoint,
						   KeyModifiers keyFlags);
	virtual void DoDoubleClick(const BR_CPoint &aPoint,
							   KeyModifiers keyFlags);
	virtual BR_Boolean DoKey(Key theKey,
							 unsigned short repeatCount,
							 BR_Boolean callSupervisor = TRUE);
	virtual BR_Boolean DoKeyDown(Key theKey,
								 unsigned short repeatCount,
								 BR_Boolean callSupervisor = TRUE);
	// New methods
	void ShowCaret();
	void HideCaret();
	void RemoveSelection();
	BR_Boolean SelectWord(const BR_CPoint& startingClick);
	BR_Boolean SelectString(const BR_TString<BR_Char>& string,
							LineNumber lineNumber,
							ColumnNumber columnNumber);
	BR_Boolean IsSelectionEmpty() const;
	LineNumber GetLineNo() const;
	ColumnNumber GetColumnNo() const;
	BR_CPoint GetCaretPosition() const;
	BR_Coordinate GetCaretX() const;

	// New virtual methods
	virtual void CalculatePosition(const BR_CPoint& inClickPoint,
								   BR_CStaticText::LineNumber& outLineNumber,
								   BR_CStaticText::ColumnNumber& outColumnNumber,
								   BR_CPoint& outCaretPoint);
	virtual void CalculatePosition(BR_CStaticText::LineNumber inLineNumber,
								   BR_CStaticText::ColumnNumber inColumnNumber,
								   BR_CStaticText::LineNumber& outLineNumber,
								   BR_CStaticText::ColumnNumber& outColumnNumber,
								   BR_CPoint& outCaretPoint);
	virtual void SetPosition(const BR_CPoint& clickPoint);
	virtual void SetPosition(LineNumber lineNumber,
							 ColumnNumber columnNumber);
	virtual BR_Boolean DoLeftKey();
	virtual BR_Boolean DoRightKey();
	virtual BR_Boolean MoveWordLeft();
	virtual BR_Boolean MoveWordRight();
	virtual BR_Boolean DoUpKey();
	virtual BR_Boolean DoDownKey();
	virtual BR_Boolean DoHomeKey();
	virtual BR_Boolean DoEndKey();
	virtual void DoShiftClick(const BR_CPoint& mousePoint,
							  KeyModifiers keys);
	virtual void ExtendSelection(const BR_CPoint& mousePoint);

	typedef BR_Boolean(BR_CSelectText::*EXTENDSELFUNC)(void);
	virtual void ExtendSelection(EXTENDSELFUNC);

protected:
	virtual void Draw(BR_CCanvas &canvas, const BR_CRectangle& area);
	virtual void AdjustToFont();
	virtual void UpdatePosition(LineNumber newLine,
								ColumnNumber newColumn,
								const BR_CPoint& newCaretPosition);
	virtual void CheckPosition();
	virtual void SetLineNo(LineNumber newLine);
	virtual void SetColumnNo(ColumnNumber newColumn);

	BR_CTextSelection* GetTextSelection() const;
	BR_Boolean CopyTextSelection(BR_CTextStream& textStream) const;
	BR_Boolean CopyClipboard() const;
	virtual BR_Boolean CreateSelection(LineNumber startLine,
									   ColumnNumber startColumn,
									   LineNumber endLine,
									   ColumnNumber endColumn);
	BR_Boolean IsTextSelectionLocked() const;
	void LockTextSelection();
	void UnlockTextSelection();

private:
	LineNumber fCurrentLineNumber;				// The current line
	ColumnNumber fCurrentColumn;				// The current column
	BR_CPoint fCaretPosition;					// The caret position
	short fSelectionLockedCount;				// Is the selection locked
	BR_CCaret* fCaret;							// This instance's caret
	unsigned short fCaretWidth;							// Width of the caret

	void CreateCaret();
	void DeleteCaret();
	void AdjustCaretToFont();
	BR_CTextSelection* GetCurrentOrCreateNewSelection();
	BR_Boolean PutClipboardData(BR_PlatformHandle dataHandle) const;
	void InitSelectText();

	BR_SETCLASSNAME(BR_CSelectText);
};

//========================================================================================
//	CLASS BR_CAcquireSelectTextLock
//
//		ctor	- Locks   selectText's selection
//		dtor	- Unlocks selectText's selection
//========================================================================================

class BR_CAcquireSelectTextLock : public _BR_CAutoDestructObject
{
public:
						BR_CAcquireSelectTextLock(BR_CSelectText *selectText);
					   ~BR_CAcquireSelectTextLock();
private:
	BR_CSelectText		   *fSelectText;
};


//========================================================================================
//	INLINE METHODS - BR_CSelectText
//========================================================================================

//----------------------------------------------------------------------------------------
// BR_CSelectText::GetLineNo
//----------------------------------------------------------------------------------------

inline BR_CStaticText::LineNumber BR_CSelectText::GetLineNo() const
{
	return fCurrentLineNumber;
}

//----------------------------------------------------------------------------------------
// BR_CSelectText::GetColumnNo
//----------------------------------------------------------------------------------------

inline BR_CStaticText::ColumnNumber BR_CSelectText::GetColumnNo() const
{
	return fCurrentColumn;
}

//----------------------------------------------------------------------------------------
// BR_CSelectText::GetCaretPosition
//----------------------------------------------------------------------------------------

inline BR_CPoint BR_CSelectText::GetCaretPosition() const
{
	return fCaretPosition;
}

//----------------------------------------------------------------------------------------
// BR_CSelectText::GetCaretX
//----------------------------------------------------------------------------------------

inline BR_Coordinate BR_CSelectText::GetCaretX() const
{
	return fCaretPosition.fX;
}

#endif
