#ifndef BRSCROLL_H
#define BRSCROLL_H
//========================================================================================
//
//     File:			BRScroll.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	3/1/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================


#ifndef   BRVIEW_H
#include "BRView.h"
#endif

#ifndef   BRSCROLB_H
#include "BRScrolb.h"
#endif

#ifndef   BRSCROLL_K
#include "BRScroll.k"
#endif

#ifndef   BRSCROLE_H
#include "BRScrolE.h"
#endif

struct BR_SScrollerInfo;
class BR_CScrollerScrollBar;

//========================================================================================
// CLASS BR_CScroller
//========================================================================================

class BR_CScroller : public BR_CView
{
public:
	typedef short int ScrollBarStyle;
	typedef short int ScrollBarOffsetSelector;

	enum ScrollBarOffsetSelectorConstants
	{
		kScrollBarOffsetSelectorFromStart = 0,
		kScrollBarOffsetSelectorFromEnd = 1
	};

public:
	BR_CScroller(BR_CView* enclosure,
				 BR_CBureaucrat* supervisor,
				 ViewId viewId,
				 ViewUnits viewUnits,
				 BR_CHelp::HelpTopic helpTopic,
				 BR_Distance width,
				 BR_Distance height,
				 BR_Coordinate x,
				 BR_Coordinate y,
				 ViewSizing horizontalSizing,
				 ViewSizing verticalSizing,
				 const BR_CColor& backgroundColor,
				 const BR_SScrollerInfo& horizontalScrollerInfo,
				 const BR_SScrollerInfo& verticalScrollerInfo);
	BR_CScroller(BR_CView* enclosure,
				 BR_CBureaucrat* supervisor,
				 const BR_CModule& module,
				 BR_SResource& resource);
	~BR_CScroller();

	// Overridden virtual methods
	virtual void SetEnclosure(BR_CView* enclosure,
							  BR_CBureaucrat* supervisor = NULL);
	virtual void AddSubview(BR_CView* subview);
	virtual void RemoveSubview(BR_CView& subview);
	virtual void SubviewChangedFrame(BR_CView& subview,
									 const BR_CRectangle& oldFrame,
									 const BR_CRectangle& newFrame,
									 BR_Boolean redraw);
	virtual void SetFrame(const BR_CRectangle& rect,
						  BR_Boolean redraw);
	virtual void DoClick(const BR_CPoint& aPoint,
						 KeyModifiers keyFlags);

	// New virtual methods
	virtual BR_Boolean DoScrollEvent(const BR_CScrollEvent& scrollEvent);
	virtual void ScrollBarDeleted(BR_CScrollerScrollBar* scrollBar);

	// Non-virtual methods
	BR_CScrollBar::StepDistance GetPageSteps(BR_CPoint::XYSelector orientation,
											 BR_CScrollBar::ScrollDirection scrollDirection) const;
	BR_CScrollBar::StepDistance GetOverlapSteps(BR_CPoint::XYSelector orientation,
												BR_CScrollBar::ScrollDirection scrollDirection) const;

protected:
	// New virtual methods
	virtual void AutoScroll();
	virtual void ScrollToAPointLocation(const BR_CPoint& scrollLocation,
										BR_Boolean redraw = BR_kRedraw);
	virtual void ScrollToAStepLocation(const BR_CScrollBar::StepPosition stepLocation[2]);
	virtual void ScrollToAStepPosition(BR_CPoint::XYSelector orientation,
									   BR_CScrollBar::StepPosition stepPosition);
	virtual void ScrollByStepDistance(const BR_CScrollBar::StepDistance stepDistance[2]);
	virtual void ScrollMaximum(BR_CPoint::XYSelector orientation,
							   BR_CScrollBar::ScrollDirection direction);
	virtual void ScrollAPage(BR_CPoint::XYSelector orientation,
							 BR_CScrollBar::ScrollDirection direction);
	virtual void ScrollALine(BR_CPoint::XYSelector orientation,
							 BR_CScrollBar::ScrollDirection direction);
	virtual BR_Boolean DoScrollBarThumbTracking(BR_CPoint::XYSelector orientation,
												BR_CScrollBar::StepPosition thumbPosition);
	virtual void AdjustScrollerValues();
	virtual void AdjustScrollBarRanges();
	virtual void AdjustScrollBarThumbs();
	virtual void ConstrainToMultipleOfStepDistance(BR_CPoint& location) const;
	virtual void ConstrainByRange(BR_CPoint& location) const;
	virtual BR_Coordinate StepPositionToCoordinate(BR_CScrollBar::StepPosition stepPosition,
												   BR_CPoint::XYSelector orientation) const;
	virtual BR_CScrollBar::StepPosition CoordinateToStepPosition(BR_Coordinate coordinate,
																 BR_CPoint::XYSelector orientation) const;
	virtual BR_CPoint CalcExtentOfSubviews() const;
	virtual BR_Coordinate CalcMaxScrollCoordinate(BR_CPoint::XYSelector orientation) const;
	virtual BR_CScrollBar::StepDistance CalcPageSteps(BR_CPoint::XYSelector orientation,
													  BR_CScrollBar::ScrollDirection scrollDirection) const;
	virtual BR_CScrollBar::StepPosition CalcMaxStepPosition(BR_CPoint::XYSelector orientation) const;
	virtual void ScrollViewAndInvalidateExposedRegion(const BR_CPoint& scrollDistance,
													  BR_Boolean redraw);
	virtual BR_CScrollerScrollBar* CreateScrollBar(const BR_SScrollerInfo& scrollerInfo,
												   BR_CPoint::XYSelector orientation);
	virtual BR_CScrollerScrollBar* CreateControlScrollBar(const BR_SScrollerInfo& scrollerInfo,
														  BR_CPoint::XYSelector orientation);
	virtual BR_CScrollerScrollBar* CreateSystemScrollBar(const BR_SScrollerInfo& scrollerInfo,
														 BR_CPoint::XYSelector orientation);
	virtual BR_CScrollerScrollBar* FindScrollBar(const BR_SScrollerInfo& scrollerInfo,
												 BR_CPoint::XYSelector orientation);
	virtual void AdjustPositionOfScrollBars() const;
	virtual void AdjustToChangeInSubview();

	// Non-virtual methods
	BR_Coordinate GetCurrentLocationAsCoordinate(BR_CPoint::XYSelector orientation) const;
	BR_CScrollBar::StepPosition GetCurrentLocationAsStepPosition(BR_CPoint::XYSelector orientation) const;
	BR_CPoint GetScrollerSize() const;
	BR_Distance GetDistancePerStep(BR_CPoint::XYSelector orientation) const;
	BR_CPoint GetExtentOfSubviews() const;
	BR_Distance GetMaxScrollCoordinate(BR_CPoint::XYSelector orientation) const;
	BR_CScrollBar::StepPosition GetMaxScrollStepPosition(BR_CPoint::XYSelector orientation) const;
	BR_CScrollerScrollBar* GetScrollBar(BR_CPoint::XYSelector orientation) const;
	ScrollBarStyle GetScrollBarStyle(BR_CPoint::XYSelector orientation) const;
	BR_Distance GetScrollBarOffset(BR_CPoint::XYSelector orientation,
								   ScrollBarOffsetSelector selector) const;
	BR_Boolean IsConstrainedToMultipleOfStepDistance() const;
	BR_Boolean IsConstrainedByRange() const;
	void SetDistancePerStep(BR_Distance distance,
							BR_CPoint::XYSelector orientation);
	void SetExtentOfSubviews(const BR_CPoint& extentOfSubviews);
	void SetMaxScrollCoordinate(BR_Distance maxDistance,
								BR_CPoint::XYSelector orientation);
	void SetMaxStepPosition(BR_CScrollBar::StepPosition maxStepPosition,
							BR_CPoint::XYSelector orientation);
	void SetOverlapSteps(BR_CScrollBar::StepDistance overlapSteps,
						 BR_CPoint::XYSelector orientation,
						 BR_CScrollBar::ScrollDirection scrollDirection);
	void SetPageSteps(BR_CScrollBar::StepDistance pageSteps,
					  BR_CPoint::XYSelector orientation,
					  BR_CScrollBar::ScrollDirection scrollDirection);
	void SetScrollBar(BR_CScrollerScrollBar* scrollerScrollBar,
					  BR_CPoint::XYSelector orientation);
	void SetConstrainedToMultipleOfStepDistance(BR_Boolean isConstrained);
	void SetConstrainedByRange(BR_Boolean isConstrained);
	BR_Boolean IsScrollBarCreatedByScroller(BR_CPoint::XYSelector orientation) const;

private:
	void InitScroller(const BR_SScrollerInfo& horizontalScrollerInfo,
					  const BR_SScrollerInfo& verticalScrollerInfo);
	void CalcAndSetExtentOfSubviews();

	BR_Distance fDistancePerStep[2];
	BR_Coordinate fMaxScrollCoordinate[2];
	BR_CScrollBar::StepPosition fMaxScrollStepPosition[2];
	BR_CPoint fExtentOfSubviews;
	BR_CScrollerScrollBar* fScrollerScrollBar[2];
	ScrollBarStyle fScrollBarStyle[2];
	BR_Distance fScrollBarThickness[2];
	BR_Distance fScrollBarOffset[2][2];
	BR_CScrollBar::StepDistance fPageSteps[2][2];
	BR_CScrollBar::StepDistance fOverlapSteps[2][2];
	BR_Boolean fConstrainedToMultipleOfStepDistance;
	BR_Boolean fConstrainedByRange;


#ifdef BR_BUILD_MAC
private:
	void BedMacAdjustScrollBarFrameForGrowBox(BR_CPoint& scrollBarFrameBottomRight,
											  BR_CPoint::XYSelector i) const;
#endif

#ifdef BR_BUILD_WIN
public:
	// Overridden virtual methods
	LONG Dispatch(WORD wMessage,
				  WORD wParam,
				  LONG lParam,
				  BR_Boolean callDefaultProc = TRUE);
#endif

	BR_SETCLASSNAME(BR_CScroller);
};


//========================================================================================
// STRUCT BR_SScrollerInfo
//========================================================================================

struct BR_SScrollerInfo
{
public:
	BR_SScrollerInfo(BR_CScroller::ScrollBarStyle scrollBarStyle = kScrollerScrollBarStyleNone);
	BR_SScrollerInfo(BR_Distance distancePerStep,
					 BR_CScrollBar::StepDistance overlapSteps,
					 BR_CScroller::ScrollBarStyle scrollBarStyle,
					 BR_CView::ViewId scrollBarId,
					 BR_CHelp::HelpTopic helpTopic,
					 BR_Distance scrollBarThickness,
					 BR_Distance scrollBarOffsetFromStart,
					 BR_Distance scrollBarOffsetFromEnd);

	BR_Distance fDistancePerStep;
	BR_CScrollBar::StepDistance fOverlapSteps;
	BR_CScroller::ScrollBarStyle fScrollBarStyle;
	BR_CView::ViewId fScrollBarId;
	BR_CHelp::HelpTopic fHelpTopic;
	BR_Distance fScrollBarThickness;
	BR_Distance fScrollBarOffset[2];

private:
	void InitScrollerInfo(BR_Distance distancePerStep,
						  BR_CScrollBar::StepDistance overlapSteps,
						  BR_CScroller::ScrollBarStyle scrollBarStyle,
						  BR_CView::ViewId scrollBarId,
						  BR_CHelp::HelpTopic helpTopic,
						  BR_Distance scrollBarThickness,
						  BR_Distance scrollBarOffsetFromStart,
						  BR_Distance scrollBarOffsetFromEnd);
};


//========================================================================================
// STRUCT BR_SScrollerResource
//========================================================================================

struct BR_SScrollerResource : BR_SViewResource
{
	BR_SScrollerInfo horizontalScrollerInfo;
	BR_SScrollerInfo verticalScrollerInfo;
};


//========================================================================================
// CLASS BR_CScrollerScrollBar
//========================================================================================

class BR_CScrollerScrollBar : public BR_CScrollBar
{
public:
	BR_CScrollerScrollBar(BR_CView* enclosure,
						  BR_CScroller* supervisor,
						  ViewId viewId,
						  ViewUnits viewUnits,
						  BR_CHelp::HelpTopic helpTopic,
						  BR_CPoint::XYSelector orientation,
						  BR_Distance length,
						  BR_Distance thickness,
						  BR_Coordinate x,
						  BR_Coordinate y,
						  ViewSizing horizontalSizing,
						  ViewSizing verticalSizing,
						  BR_Boolean create);
	BR_CScrollerScrollBar(BR_CView* enclosure,
						  BR_CBureaucrat* supervisor,
						  const BR_CModule& module,
						  BR_SResource& resource);
	virtual~ BR_CScrollerScrollBar();

	// Overridden virtual methods
	virtual StepDistance GetOverlap(ScrollDirection scrollDirection) const;
	virtual StepDistance GetPage(ScrollDirection scrollDirection) const;
	virtual void DoThumbChange(ScrollBarCommand scrollBarCommand,
							   StepPosition newStepPosition);
	
	// New virtual methods
	virtual void ScrollerDeleted(BR_CScroller* scroller);

	// Non-virtual methods
	BR_CScroller* GetScroller(void) const;
	void SetScroller(BR_CScroller* scroller);

private:
	BR_CScroller* fScroller;

	BR_SETCLASSNAME(BR_CScrollerScrollBar);
};


//========================================================================================
// STRUCT BR_SScrollerScrollBarResource
//========================================================================================

struct BR_SScrollerScrollBarResource : BR_SScrollBarRes
{
};


#ifdef BR_BUILD_WIN
//========================================================================================
// CLASS BR_CBedWinScrollerScrollBar
//========================================================================================

class BR_CBedWinScrollerScrollBar : public BR_CScrollerScrollBar
{
public:
	BR_CBedWinScrollerScrollBar(BR_CPoint::XYSelector orientation,
								BR_CScroller* scroller);
	virtual~ BR_CBedWinScrollerScrollBar();

	BR_SETCLASSNAME(BR_CBedWinScrollerScrollBar);
};
#endif

#endif
