#if !defined(BRRESOUR_H) && !defined(__BEDRC__)
#define BRRESOUR_H
//========================================================================================
//
//     File:		BRResour.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	1/21/91
//
//     COPYRIGHT 1991 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   BROBJECT_H
#include "BRObject.h"
#endif

#ifndef   BRBEDEXC_H
#include "BRBedExc.h"
#endif

#ifndef   BRMEMMGR_H
#include "BRMemMgr.h"
#endif


//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CModule;


//========================================================================================
//	CLASS BR_CResource
//========================================================================================

class BR_CResource : public BR_CObject
{
#ifdef BR_BUILD_MAC
protected:
	typedef char **BedResourceHandle;
	// typedef Handle BedResourceHandle;	CFront BUG!
#endif

#ifdef BR_BUILD_WIN
public:
	typedef HGLOBAL BedResourceHandle;
#endif


public:
	BR_CResource(const BR_CModule &module,
				 BR_ResourceId resourceId,
				 BR_ResourceType resourceType);
	virtual ~BR_CResource();
	virtual unsigned long GetSize() const;
	virtual void* GetData() const;
	virtual void ReleaseData() const;

protected:
	BedResourceHandle GetHandle() const;
	void SetHandle(BedResourceHandle resourceHandle);

private:
	BedResourceHandle fHandle;
	unsigned long fResourceSize;


#ifdef BR_BUILD_MAC
public:
	enum PredefinedResourceType
	{
		kBitmap = 'BMAP',
		kCursor = 'CURS',
		kIcon = 'ICON',
		kColorIcon = 'cicn',
		kPicture = 'PICT'
	};
	
    BedResourceHandle MacGetHandle() const;
	
private:
	unsigned short fLockCount;
#endif


#ifdef BR_BUILD_WIN
public:
	enum PredefinedResourceType
	{
		kAccelerator = 9, kBitmap = 2, kCursor = 1, kIcon = 3
	};
#endif

	BR_SETCLASSNAME(BR_CResource);
};

//----------------------------------------------------------------------------------------
// BR_CResource::GetHandle
//----------------------------------------------------------------------------------------

inline BR_CResource::BedResourceHandle BR_CResource::GetHandle() const
{
	return fHandle;
}

#ifdef BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CResource::MacGetHandle
//----------------------------------------------------------------------------------------

inline BR_CResource::BedResourceHandle BR_CResource::MacGetHandle() const
{
	return fHandle;
}
#endif

//----------------------------------------------------------------------------------------
// BR_CResource::SetHandle
//----------------------------------------------------------------------------------------

inline void BR_CResource::SetHandle(BedResourceHandle resourceHandle)
{
	fHandle = resourceHandle;
}

//========================================================================================
// CLASS BR_CAcquireResourceData
//
// ctor - Gets     resource data via GetData()
// dtor - Releases resource data via ReleaseData()
//========================================================================================

class BR_CAcquireResourceData : public _BR_CAutoDestructObject
{
public:
	BR_CAcquireResourceData(const BR_CResource* resource);
	~BR_CAcquireResourceData();
	virtual void *GetData() const;
	
private:
	const BR_CResource* fResource;
	void* fData;
};


//========================================================================================
//	STRUCT BR_SResource
//========================================================================================

struct BR_SResource
{
    unsigned short dummy;
};


//========================================================================================
//	STRUCT BR_SResourceHeader
//========================================================================================

struct BR_SResourceHeader
{
	unsigned short fLength;
	unsigned short fId;
	unsigned short fEnclosureId;
	char fClassName[1];

	BR_SResource* GetResStruct() const;
	BR_SResourceHeader* GetNextRes() const;
};

//----------------------------------------------------------------------------------------
// BR_SResourceHeader::GetNextRes
//----------------------------------------------------------------------------------------

inline BR_SResourceHeader* BR_SResourceHeader::GetNextRes() const
{
	return (BR_SResourceHeader *) & (((LPSTR)((void*)this))[fLength]);
}


//========================================================================================
// EXCEPTION BR_XResource
//		Base class for all resource exceptions except BR_XResourceMemoryExhausted.
//========================================================================================

class BR_XResource : public BR_XBedException
{
public:
	enum ResourceInfoAvailability
	{
		kResourceInfoNotAvailable,				// Module, Id, and Type are NOT available
		kResourceInfoAvailable					// Module, Id, and Type are available
	};

	BR_XResource();
	BR_XResource(PlatformError fError);
	BR_XResource(const BR_CModule* module,
				 BR_ResourceId resourceId,
				 BR_ResourceType resourceType);
	BR_XResource(const BR_CModule* module,
				 BR_ResourceId resourceId,
				 BR_ResourceType resourceType,
				 PlatformError platformError);
	virtual~ BR_XResource();
	ResourceInfoAvailability GetResourceInfoAvailability() const;
	const BR_CModule* GetResourceModule() const;
	BR_ResourceId GetResourceId() const;
	BR_ResourceType GetResourceType() const;
	_BR_EXCEPTION_DEFINE(BR_XResource);
	
private:
	ResourceInfoAvailability fResourceInfoAvailability;
	const BR_CModule* fModule;
	BR_ResourceId fResourceId;
	BR_ResourceType fResourceType;
};


//========================================================================================
// EXCEPTION BR_XResourceCannotLock - Loaded resource could not be locked.
//========================================================================================

class BR_XResourceCannotLock : public BR_XResource
{
public:
	BR_XResourceCannotLock();
	virtual~ BR_XResourceCannotLock();
	_BR_EXCEPTION_DEFINE(BR_XResourceCannotLock);
};


//========================================================================================
// EXCEPTION BR_XResourceNotFound - Resource was not loaded as it was not found.
//========================================================================================

class BR_XResourceNotFound : public BR_XResource
{
public:
	BR_XResourceNotFound(const BR_CModule* module,
						 BR_ResourceId resourceId,
						 BR_ResourceType resourceType);
	virtual~ BR_XResourceNotFound();
	_BR_EXCEPTION_DEFINE(BR_XResourceNotFound);
};


//========================================================================================
// EXCEPTION BR_XResourceNotLoaded - Resource exists but could not be loaded.
//========================================================================================

class BR_XResourceNotLoaded : public BR_XResource
{
public:
	BR_XResourceNotLoaded(const BR_CModule* module,
						  BR_ResourceId resourceId,
						  BR_ResourceType resourceType);
	BR_XResourceNotLoaded(const BR_CModule* module,
						  BR_ResourceId resourceId,
						  BR_ResourceType resourceType,
						  PlatformError platformError);
	virtual~ BR_XResourceNotLoaded();
	_BR_EXCEPTION_DEFINE(BR_XResourceNotLoaded);
};


//========================================================================================
// EXCEPTION BR_XResourceMemoryExhausted - Memory exhausted during resource loading.
//========================================================================================

class BR_XResourceMemoryExhausted : public BR_XMemoryExhausted
{
public:
	BR_XResourceMemoryExhausted(const BR_CModule* module,
								BR_ResourceId resourceId,
								BR_ResourceType resourceType);
	virtual~ BR_XResourceMemoryExhausted();
	const BR_XResource* GetResourceInstance() const;
	_BR_EXCEPTION_DEFINE(BR_XResourceMemoryExhausted);
	
private:
	BR_XResource fResourceInstance;
};

//----------------------------------------------------------------------------------------
// BR_XResource::GetResourceInfoAvailability
//----------------------------------------------------------------------------------------

inline BR_XResource::ResourceInfoAvailability
BR_XResource::GetResourceInfoAvailability() const
{
	return fResourceInfoAvailability;
}

//----------------------------------------------------------------------------------------
// BR_XResource::GetResourceModule
//----------------------------------------------------------------------------------------

inline const BR_CModule* BR_XResource::GetResourceModule() const
{
	return fModule;
}

//----------------------------------------------------------------------------------------
// BR_XResource::GetResourceId
//----------------------------------------------------------------------------------------

inline BR_ResourceId BR_XResource::GetResourceId() const
{
	return fResourceId;
}

//----------------------------------------------------------------------------------------
// BR_XResource::GetResourceType
//----------------------------------------------------------------------------------------

inline BR_ResourceType BR_XResource::GetResourceType() const
{
	return fResourceType;
}

//----------------------------------------------------------------------------------------
// BR_XResourceCannotLock::BR_XResourceCannotLock
//----------------------------------------------------------------------------------------

inline BR_XResourceCannotLock::BR_XResourceCannotLock() :
	BR_XResource()
{
}

//----------------------------------------------------------------------------------------
// BR_XResourceNotFound::BR_XResourceNotFound
//----------------------------------------------------------------------------------------

inline BR_XResourceNotFound::BR_XResourceNotFound(const BR_CModule* module,
												  BR_ResourceId resourceId,
												  BR_ResourceType resourceType) :
	BR_XResource(module, resourceId, resourceType)
{
}

//----------------------------------------------------------------------------------------
// BR_XResourceNotLoaded::BR_XResourceNotLoaded
//----------------------------------------------------------------------------------------

inline BR_XResourceNotLoaded::BR_XResourceNotLoaded(const BR_CModule* module,
													BR_ResourceId resourceId,
													BR_ResourceType resourceType) :
	BR_XResource(module, resourceId, resourceType)
{
}

//----------------------------------------------------------------------------------------
// BR_XResourceNotLoaded::BR_XResourceNotLoaded
//----------------------------------------------------------------------------------------

inline BR_XResourceNotLoaded::BR_XResourceNotLoaded(const BR_CModule* module,
													BR_ResourceId resourceId,
													BR_ResourceType resourceType,
													PlatformError platformError) :
	BR_XResource(module, resourceId, resourceType, platformError)
{
}

//----------------------------------------------------------------------------------------
// BR_XResourceMemoryExhausted::BR_XResourceMemoryExhausted
//----------------------------------------------------------------------------------------

inline BR_XResourceMemoryExhausted::BR_XResourceMemoryExhausted(const BR_CModule* module,
																BR_ResourceId resourceId,
																BR_ResourceType resourceType) :
	BR_XMemoryExhausted(),
	fResourceInstance(module, resourceId, resourceType)
{
}

//----------------------------------------------------------------------------------------
// BR_XResourceMemoryExhausted::GetResourceInstance
//----------------------------------------------------------------------------------------

inline const BR_XResource* BR_XResourceMemoryExhausted::GetResourceInstance() const
{
	return &fResourceInstance;
}

#endif
