#if !defined(BRRADIOB_H) && !defined(__BEDRC__)
#define BRRADIOB_H
//========================================================================================
//
//     File:			BRRadioB.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	October 18, 1990
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRBUTTON_H
#include "BRButton.h"
#endif


//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CRadioGroup;


//========================================================================================
// STRUCT BR_SRadioButtonResource
//========================================================================================

struct BR_SRadioButtonResource : BR_SCheckedButtonResource
{
};


//========================================================================================
// CLASS BR_CRadioButton
//========================================================================================

class BR_CRadioButton : public BR_CCheckedButton
{
public:
	BR_CRadioButton(BR_CView *enclosure,
					BR_CRadioGroup *supervisor,
					BR_Distance width,
					BR_Distance height,
					BR_Coordinate x,
					BR_Coordinate y,
					ViewSizing horizontalSizing,
					ViewSizing verticalSizing,
					ViewId id,
					const BR_TString<BR_Char> &text,
					BR_Boolean isAuto = FALSE);

	BR_CRadioButton(BR_CView *enclosure,
					BR_CBureaucrat *supervisor,
					const BR_CModule &module,
					BR_SResource &viewResource);

	virtual~ BR_CRadioButton();
	
#ifdef BR_BUILD_MAC
public:
	virtual void DoGoodClick(short partCode);		// ?INTERNAL?
#endif

#ifdef BR_BUILD_WIN
public:
	BR_CRadioButton(BR_CView* enclosure,
					BR_CRadioGroup* supervisor,
					BR_Distance width,
					BR_Distance height,
					BR_Coordinate x,
					BR_Coordinate y,
					ViewSizing horizontalSizing,
					ViewSizing verticalSizing,
					ViewId id,
					const BR_TString<BR_Char>& text,
					ViewStyle viewStyle);
					
	virtual long Dispatch(WORD wMessage,
						  WORD wParam,
						  long lParam,
						  BR_Boolean callDefaultProc = TRUE);		// ?INTERNAL?
#endif

	BR_SETCLASSNAME(BR_CRadioButton);
};

#endif
