#if !defined(BRPRINTE_H) && !defined(__BEDRC__)
#define BRPRINTE_H
//========================================================================================
//
//     File:		BRPrinte.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	January 2, 1990
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BROBJECT_H
#include "BRObject.h"
#endif

#ifndef BRCANVAS_H
#include "BRCanvas.h"
#endif

#ifndef BRPRINTM_H
#include "BRPrintM.h"
#endif

#ifndef BRGRHELP_H
#include "BRGrHelp.h"
#endif

#ifndef BRPRINFO_H
#include "BRPrInfo.h"
#endif

#ifndef BRREGION_H
#include "BRRegion.h"
#endif

#ifndef BRDOCUME_H
#include "BRDocume.h"
#endif

#ifdef BR_BUILD_MAC
//========================================================================================
// Forward struct declarations
//========================================================================================

struct GrafPort;
struct TPrPort;
#endif

//========================================================================================
// CLASS BR_CPrinter
//========================================================================================

class BR_CPrinter : public BR_CCanvas
{
public:
	enum
	{
		kDontThrowExceptions = FALSE, kOKToThrowExceptions = TRUE
	};


	BR_CPrinter(BR_CDocument* itsSupervisor,
						 BR_CView* printPane,
						 BR_CPrinterInfo* printerInfo);
	virtual~ BR_CPrinter();

	virtual void AdornPage(BR_CDocument::AdornPhase phase);

	virtual void CloseDoc(BR_Boolean okToThrowExceptions = TRUE);
	virtual void ClosePage(BR_Boolean okToThrowExceptions = TRUE);

	virtual void GetDrawArea(BR_CRectangle& rPrintArea) const;
	virtual void GetResolution(BR_CPoint& ptResolution) const;

	virtual void OpenDoc(BR_CDocument& document);
	virtual void OpenPage(unsigned long pageNumber);

protected:
	virtual void GetPagePrintingOffset(BR_CPoint& aPoint) const;
	virtual BR_CPrinterInfo* GetPrinterInfo() const;

	virtual void PaneToPrintingPaneCoordinates(BR_CPoint& aPoint) const;
	virtual void PrintingPaneToPaneCoordinates(BR_CPoint& aPoint) const;
	virtual void PrintingPaneToPaneUnits(BR_CPoint& aPoint) const;
	virtual void PaneToPrintingPaneUnits(BR_CPoint& aPoint) const;
	void PrinterToPaneUnits(const BR_CView& pane,
									 BR_CPoint& aPoint) const;
	void PaneToPrinterUnits(const BR_CView& pane,
									 BR_CPoint& aPoint) const;
	virtual BR_CView* GetPrintingPane() const;

private:
	// in fPrintingPane units:
	BR_CRectangle fPrintingRectangle;
	BR_CRectangle fInkableRectangle;
	BR_CRectangle fPaperRectangle;

	void GetInkableRectangle(BR_CRectangle& theInkArea) const;
	void GetPaperRectangle(BR_CRectangle& paperArea) const;
	void GetPrintingRectangle(BR_CRectangle& printingArea) const;

	BR_CView* fPrintingPane;					// the root pane which is being printed.
	BR_CDocument* fDocument;
	BR_CPrinterInfo* fPrinterInfo;				// info about this printer
	BR_CPoint fResolution;						// The printer's resolution
	BR_CRectangle fMinimumMargins;				// Non-printable margins size
	unsigned long fPageNumber;				// current page number
	BR_Boolean fAdorning;						// true if we are in the middle of adorning
	BR_CView* fAdorningPane;					// pane (if any, we are currently adorning)

#ifdef BR_BUILD_MAC
public:
	virtual GrafPtr BedMacGetGrafPort() const;
	virtual void BedMacViewToCanvasOwner(BR_CPoint& aPoint) const;

private:
	TPrPort* fPrPort;
#endif

#ifdef BR_BUILD_WIN
public:
	virtual HDC	BedWinCreateDC(BR_CView& Pane);
	virtual void ClosePane(const BR_CDrawStateData& drawStateData);
	virtual void BedWinDeleteDC(BR_CView& thePane,
						   HDC hDC);
	BR_CWinPrintManager* GetHDCPrinter() const;

	virtual void OpenPane(BR_CDrawStateData& drawStateData);
	virtual void BedRestoreNullClipRgn();
	virtual void BedReinitGraphicsCache(BR_CView *theView);
	virtual void ResumePane(const BR_CDrawStateData& drawStateData);
	virtual void BedSelectClipRgn(BR_CRegion* region);
	virtual void SuspendPane(BR_CDrawStateData& drawStateData);
	virtual BR_CPoint GetDeviceResolution() const;
	
private:
	void BedWinDeleteRegions();
	void BedWinReCreateRegions(const BR_CRegion* region);
	void BedWinReCreateRegions();

	BR_CWinPrintManager* fHDCPrinter;
	BR_CRectangle fWinPaneApertureRect;
	POINT fWinScaling;
	HRGN fWinGraphicsClipRgn;
	HRGN fWinTextClipRgn;

#endif

	BR_SETCLASSNAME(BR_CPrinter);
};
#endif
