#if !defined(BRPRINFO_H) && !defined(__BEDRC__)
#define BRPRINFO_H
//========================================================================================
//
//     File:			BRPrInfo.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	April 14, 1992
//
//     COPYRIGHT 1992-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRVIEW_H
#include "BRView.h"
#endif

#ifndef BRCHRSTR_H
#include "BRChrStr.h"
#endif

#ifndef BRRECT_H
#include "BRRect.h"
#endif

#if defined(BR_BUILD_MAC) && !defined(__PRINTING__)
#include <Printing.h>
#endif

#if defined(BR_BUILD_WIN) && !defined(_INC_COMMDLG)
#include <Commdlg.h>
#endif

#if defined(BR_BUILD_WIN) && !defined(DRIVINIT_H)
#include "drivinit.h"
#endif

//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CDocument;
class BR_CStream;
class BR_CPrinter;
class BR_CWindow;


#ifdef BR_BUILD_MAC
//========================================================================================
// Forward struct declarations
//========================================================================================

struct GrafPort;
struct TPrPort;
#endif


#ifdef BR_BUILD_WIN
//========================================================================================
// STRUCT BR_SPrinterInfoData
// Structure for fMemory block which is used to save BR_CPrinterInfo
//========================================================================================

struct BR_SPrinterInfoData
{
	unsigned short fNameSize;				// Size of DEVNAMES structure
	unsigned short fModeSize;				// Size of DEVMODE structure

	// Here goes DEVNAMES data
	// Here goes DEVMODE data
};
#endif

//========================================================================================
// CLASS BR_CError
//========================================================================================

class BR_CPrinterInfo : public BR_CObject
{
public:
	typedef unsigned long int Page;
	typedef unsigned long int Margin;
	typedef unsigned long int Scaler;
	typedef unsigned short int Resolution;

	BR_CPrinterInfo(BR_CDocument* itsDocument,
					BR_CView::ViewUnits inUnits = kEnclosureUnits);
	// using kEnclosureUnits selects the units of the documents printing pane.
	// If no such pane exists (or if kPixelUnits are requested),
	//  BEDXF_HIMETRICS will be used

	BR_CPrinterInfo(BR_CDocument* itsDocument,
					BR_CStream& itsStream);
	virtual~ BR_CPrinterInfo();

	virtual unsigned long GetCopyCount() const;
	// How many copies does the document need to print.
	// This may not be the same as the number of copies the user
	// selected, because the printer may do multiple copies.

	virtual BR_Boolean IsCollating() const;
	// Has the user selected collation

	virtual void GetPages(Page& first,
						  Page& last) const;
	// What page range did the user select

	virtual BR_Boolean GetOrientation();
	// What orientation has been selected (true for portrait)

	virtual void SetOrientation(BR_Boolean portrait);
	// Set the orientation

	virtual void GetMargins(Margin& left,
							Margin& top,
							Margin& right,
							Margin& bottom) const;

	virtual void GetMargins(Margin& left,
							Margin& top,
							Margin& right,
							Margin& bottom,
							BR_CView::ViewUnits inWhatUnits) const;
	// The margins (all values will normally be non-negative).

	virtual void SetMargins(Margin left,
							Margin top,
							Margin right,
							Margin bottom);

	virtual void SetMargins(Margin mLeft,
							Margin mTop,
							Margin mRight,
							Margin mBottom,
							BR_CView::ViewUnits inWhatUnits);
	// Should not be called if minimal margins are set

	virtual void GetMinMargins(Margin& left,
							   Margin& top,
							   Margin& right,
							   Margin& bottom) const;

	virtual void GetMinMargins(Margin& left,
							   Margin& top,
							   Margin& right,
							   Margin& bottom,
							   BR_CView::ViewUnits inWhatUnits) const;
	// returns the smallest margins the printer supports

	virtual void SetWantsMinimalMargins(BR_Boolean wantsMinimal);
	virtual BR_Boolean GetWantsMinimalMargins() const;
	// If you always want to use the maximum printable area of the printer regardless of
	// printer, use minimal margins. This enforces that the printing rectangle is the same
	// as the inkable rectangle

	virtual void GetPrinterName(BR_TString<BR_Char>& strName) const;
	// returns the kind of printer (not the network printer name).

	virtual void SetUnits(BR_CView::ViewUnits newUnits);
	virtual BR_CView::ViewUnits GetUnits() const;
	// the units in which measurements are reported.

	virtual void SetDocumentSetupButton(BR_Boolean wantsButton);
	virtual void SetDocumentSetupButton(const BR_TString<BR_Char>& buttonTitle);
	virtual BR_Boolean GetDocumentSetupButton(BR_TString<BR_Char>& buttonTitle) const;
	// On the mac, we use a button in Page setup to bring up the equivalent of
	// Page Setup in windows.  This sets up that button if so desired
	// On Windows, these do nothing.

	virtual void GetPrintingRectangle(BR_CRectangle& r) const;
	virtual void GetPrintingRectangle(BR_CRectangle& r,
									  BR_CView::ViewUnits inWhatUnits) const;
	// Paper rectangle minus the margins

	virtual void GetInkableRectangle(BR_CRectangle& theInk) const;
	virtual void GetInkableRectangle(BR_CRectangle& theInk,
									 BR_CView::ViewUnits inWhatUnits) const;
	// Maximum rectangle the printer can print

	virtual void GetPaperRectangle(BR_CRectangle& r) const;
	virtual void GetPaperRectangle(BR_CRectangle& r,
								   BR_CView::ViewUnits inWhatUnits) const;
	// Paper size (top-left is 0, 0)

	virtual void GetReduceEnlargePercentage(Scaler& numerator,
											Scaler& denominator) const;
	// Should this be a fFixed or fract?

	virtual void GetResolution(Resolution& x,
							   Resolution& y) const;

	virtual void LoadData(BR_CStream& stream);
	// Loads the info from the stream.  Can be called multiple times per instantiation

	virtual void SaveData(BR_CStream& stream);
	// Saves the data into the stream

protected:
	virtual void BedLoadData(BR_CStream& stream);
	// Loads just the platform-independent portion of the information.

	virtual void BedSaveData(BR_CStream& stream);
	// Saved just the platform-independent portion of the information

private:
	// Handy conversion routines
	virtual void TranslateUnits(BR_CPoint& points,
								unsigned short numPts,
								BR_CView::ViewUnits inUnit,
								BR_CView::ViewUnits outUnit) const;

	void TranslateUnits(BR_CPoint& pt,
						BR_CView::ViewUnits inUnit,
						BR_CView::ViewUnits outUnit) const;

	void TranslateUnits(BR_CRectangle& rRect,
						BR_CView::ViewUnits inUnit,
						BR_CView::ViewUnits outUnit) const;

	BR_Boolean fWantsMinimalMargins;
	BR_CView::ViewUnits fUnits;
	BR_CDocument* fDocument;
	Margin fTopMargin, fLeftMargin, fBottomMargin, fRightMargin;

#ifdef BR_BUILD_MAC
public:
	virtual THPrint MacGetPrintRecord() const;
	virtual void MacSetPrintRecord(THPrint printRecord);
	virtual void MacPrintRecordChanged();

protected:
	virtual void BedMacLoadData(BR_CStream& stream);
	// Loads THPrint record from the stream

	virtual void BedMacSaveData(BR_CStream& stream);
	// Saves THPrint record to the stream

private:
	THPrint fPrintRecord;
	BR_Boolean fWantsDocumentSetupButton;
	BR_CCharString32 fDocumentSetupButtonTitle;
#endif

#ifdef BR_BUILD_WIN
public:
	DEVMODE* WinGetDevMode() const;
	void WinReleaseDevMode() const;
	virtual void WinSetDevMode(HANDLE devModeHandle);
	virtual HDC WinGetDC(BR_Boolean info = FALSE) const;

	PRINTDLG* WinGetPRINTDLG() const;

	virtual BR_Boolean WinInit(const BR_CWindow* Window,
									DWORD dwFlags);

protected:
	virtual void BedWinLoadData(BR_CStream& stream);
	// Loads the Windows portion of information

	virtual void BedWinSaveData(BR_CStream& stream) const;
	// Saves the Windows portion of information

private:
	PRINTDLG fPrintInfo;						// CommonDialog info struct
#endif

	BR_SETCLASSNAME(BR_CPrinterInfo);
};

#endif
