#if !defined(BRPICTUR_H) && !defined(__BEDRC__)
#define BRPICTUR_H
//========================================================================================
//
//     File:		BRPictur.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	12/16/90
//
//     COPYRIGHT 1990-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRVIEW_H
#include "BRView.h" 
#endif

#ifndef BRCANVAS_H
#include "BRCanvas.h"
#endif

#ifndef BRFILESP_H
#include "BRFileSp.h"
#endif

#if defined(BR_BUILD_MAC) && !defined(__QUICKDRAW__)
#include <QuickDraw.h>
#endif

//========================================================================================
//	Forward class declarations
//========================================================================================

class BR_CStream;

#ifdef BR_BUILD_WIN
//========================================================================================
// 	BR_SWinAldusMetaFileHeader
//	Aldus format metafiles (also known as "placeable" metafiles) are
// 	regular MS Window metafiles with this header prefix.
//========================================================================================
struct BR_SWinAldusMetaFileHeader
{
	DWORD fKey;									// 0x9AC6CDD7 if Aldus metafile.
	HANDLE fHMF;									// Unused.
	RECT fBoundingBox;									// Bounding box enclosing picture.
	WORD fInch;									// Number of units-per-fInch for 'fBoundingBox' values.
	DWORD fReserved;								// Unused.
	WORD fCheckSum;								// XOR sum of first ten words of the header.
};


const DWORD kAldusKey = 0x9AC6CDD7;
#endif

//========================================================================================
//	Typedef
//========================================================================================
// Should be move elsewhere

#ifdef BR_BUILD_WIN
typedef HMETAFILE	BR_PlatformPictHandle;
#endif

#ifdef BR_BUILD_MAC
typedef PicHandle BR_PlatformPictHandle;
#endif

//========================================================================================
// CLASS BR_CPicture
//========================================================================================

class BR_CPicture : public BR_CCanvas
{
public:
	enum FileSpecOptions
	{
		kDoNotLoad = 0,							// Use the filespec to in BeginDrawing
		kLoadFromFile = 1						// Load the picture from the file
	};

public:
	BR_CPicture();

	BR_CPicture(const BR_CFileSpecification& fileSpec,
				FileSpecOptions fileSpecOptions);

	BR_CPicture(const BR_CPicture& picture);

	virtual		~BR_CPicture();

	// ----- Operators
	BR_CPicture& 		operator=(const BR_CPicture& picture);

	// ----- Override from BR_CCanvas
	virtual void 		GetDrawArea(BR_CRectangle& area) const;
	
	// ----- Override from BR_CCanvas
	virtual void 		SetPixel(BR_Coordinate X,
						  		BR_Coordinate Y,
						  		const BR_CColor& clrPixel);
	virtual BR_CColor 	GetPixel(BR_Coordinate X,
							   	BR_Coordinate Y) const;

	// ----- Rendering
	void 				Draw(BR_CCanvas& canvas,
			  				BR_Coordinate X,
			  				BR_Coordinate Y,
			  				BR_RasterOperation mode = BEDROP_SRCCOPY);

	void 				Draw(BR_CCanvas& canvas,
			  				BR_Coordinate X,
			  				BR_Coordinate Y,
			  				const BR_CRectangle &srcRect,
			  				BR_RasterOperation mode = BEDROP_SRCCOPY);
	// Draws a part of the picture defined by srcRect on the Canvas, staring at X,Y point.

	void 				Stretch(BR_CCanvas& canvas,
				 				BR_Coordinate X,
				 				BR_Coordinate Y,
				 				BR_Distance width,
				 				BR_Distance height,
				 				BR_RasterOperation mode = BEDROP_SRCCOPY);

	void 				Stretch(BR_CCanvas& canvas,
				 				BR_Coordinate X,
				 				BR_Coordinate Y,
				 				BR_Distance width,
				 				BR_Distance height,
				 				const BR_CRectangle &srcRect,
				 				BR_RasterOperation mode = BEDROP_SRCCOPY);
	// Same as the above but also stretch the resulting image so that it's xWidht by
	// xHeight.

	// ----- Load/Save picture
	virtual void 			LoadFrom(BR_CStream& stream);
	virtual void 			SaveTo(BR_CStream& stream);
	BR_Boolean				GetFileSpec(BR_CFileSpecification& FileSpec) const;


	// ------ Get/Set platform picture 
	void					SetPlatformPictHandle(BR_PlatformPictHandle pictHandle);
	BR_PlatformPictHandle	GetPlatformPictHandle() const;

protected:
	void 					InitPicture();
	virtual void 			FreePicture();
		
private:
	BR_CFileSpecification* 	fFileSpec;						// Name of the file that the picture is associated with
	BR_PlatformPictHandle 	fPictureHandle;
	
	//----------------------------------------------------------------------------------------
	// Windows
	//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_WIN
public:
	virtual HDC 	BedWinCreateDC(BR_CView& pane);
	virtual void 	BedWinDeleteDC(BR_CView& pane, HDC hDC);
	
	// Values associated with Aldus-type metafiles
	BR_Boolean 		IsPlaceable() const;
	void 			GetPlaceableBounds(BR_CRectangle& bounds) const;
	short 			GetPlaceableUnitsPerInch() const;

protected:
	WORD 			BedWinComputeAldusCheckSum(const BR_SWinAldusMetaFileHeader& aldusHeader) const;

private:
	// Values associated with Aldus-type metafiles
	BR_Boolean 		fIsPlaceable;
	BR_CRectangle 	fPlaceableBounds;
	WORD 			fPlaceableUnitsPerInch;
#endif

//----------------------------------------------------------------------------------------
//	Macintosh
//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_MAC
public:
	BR_CPicture(const BR_CResource& picture);

	void 				MacSetNewPicture(BR_PlatformPictHandle hPicture);
	unsigned short 	GetVersion(BR_PlatformPictHandle pictureHandle) const;
	virtual BR_Boolean BedMacGetBitMap(BitMap*& someMap) const;
	virtual GrafPtr 	BedMacGetGrafPort() const;	// ?INTERNAL?
	virtual void 		BedMacViewToCanvasOwner(BR_CPoint &aPoint) const;	// ?INTERNAL?
	virtual void 		ClosePane(const BR_CDrawStateData& drawStateData);
	virtual void 		OpenPane(BR_CDrawStateData& drawStateData);

private:
	GrafPtr				fPicturePort;
#endif

	BR_SETCLASSNAME(BR_CPicture);
};

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
//	BR_CPicture::IsPlaceable
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CPicture::IsPlaceable() const
{
	return fIsPlaceable;
}
#endif

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
//	BR_CPicture::GetPlaceableBounds
//----------------------------------------------------------------------------------------
inline void BR_CPicture::GetPlaceableBounds(BR_CRectangle& bounds) const
{
	bounds = fPlaceableBounds;
}
#endif

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
//	BR_CPicture::GetPlaceableUnitsPerInch
//----------------------------------------------------------------------------------------
inline short BR_CPicture::GetPlaceableUnitsPerInch() const
{
	return fPlaceableUnitsPerInch;
}
#endif

//----------------------------------------------------------------------------------------
//	BR_CPicture::GetPlatformPictHandle
//----------------------------------------------------------------------------------------
inline BR_PlatformPictHandle BR_CPicture::GetPlatformPictHandle() const
{
	return fPictureHandle;
}

//----------------------------------------------------------------------------------------
//	BR_CPicture::SetPlatformPictHandle
//----------------------------------------------------------------------------------------
inline void BR_CPicture::SetPlatformPictHandle(BR_PlatformPictHandle pictHandle)
{
	fPictureHandle = pictHandle;
}

#endif


