#if !defined(BRPEN_H) && !defined(__BEDRC__)
#define BRPEN_H
//========================================================================================
//
//     File:			BRPen.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	November 18, 1990
//
//     COPYRIGHT 1990-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRPEN_K
#include "BRPen.k"
#endif

#ifndef BRGRAPHT_H
#include "BRGraphT.h"
#endif

#ifndef BRCOLOR_H
#include "BRColor.h"
#endif


//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CView;
class BR_CCanvas;
class BR_CColor;
class BR_CBedWallPaper;
class BR_CBedPen;


//========================================================================================
// CLASS BR_CPen
// An graphics tool that controls how lines are drawn
//========================================================================================

class BR_CPen : public BR_CGraphicsTool
{
	friend BR_CGraphicsToolSelector;
	friend BR_CCanvas;

public:
	typedef unsigned short int PenStyle;
	typedef unsigned short int PenThickness;

public:
	BR_CPen(PenThickness thickness,
			const BR_CColor& penColor,
			PenStyle penStyle);

	BR_CPen(PenThickness thickness,
			const BR_CColor& penColor);

	BR_CPen(const BR_CColor& penColor);

	BR_CPen();

	// This one will create either a pattern pen or a line pen depending on whether penPattern
	// is a pattern or pen style
	BR_CPen(PenThickness thickness,
			const BR_CColor& penColor,
			const BR_CColor& fillColor,
			unsigned short penPatternOrStyle);	// can't use penStyle or BR_Pattern

	virtual~ BR_CPen();

	BR_CPen(const BR_CPen& pen);
	BR_CPen& operator=(const BR_CPen& pen);

	PenThickness GetThickness() const;
	BR_Boolean IsPatternPen() const;

	unsigned short GetStyle() const;			// Or pattern if the pen is a pattern pen
	BR_CColor GetDashColor() const;				// Or pattern hatch color -- " --
	BR_CColor GetGapColor() const;				// Or pattern fill color -- " --

	void Set(PenThickness thickness,
			 const BR_CColor& penColor,
			 const BR_CColor& fillColor,
			 unsigned short penPatternOrStyle);	// can't use penStyle or BR_Pattern

	void SetThickness(PenThickness thickness);
	void SetDashColor(const BR_CColor& dashColor);
	void SetGapColor(const BR_CColor& gapColor);
	void SetStyle(unsigned short penPatternOrStyle);// can't use PenStyle or BR_Pattern

	PenThickness GetScaledThickness(const BR_CView &pane) const;// ?INTERNAL?
	BR_CBedWallPaper* BedGetWallPaper() const;		// ?INTERNAL?
	BR_CBedPen* BedGetPen() const;					// ?INTERNAL?
	BR_Boolean IsInvisible() const;					// ?INTERNAL?
	BR_Boolean BedIsGapTransparent() const;		// ?INTERNAL?

protected:
	virtual void RestoreNullTool(BR_CView& pane);
	virtual BR_CGraphicsTool* GetCurrentTool(const BR_CCanvas& canvas) const;
	virtual void SetCurrentTool(BR_CCanvas& canvas,
								BR_CGraphicsTool* pGraphicsTool) const;

	virtual void OnAttributeChange();
	void Create();
	void Dispose();

	void Set(PenThickness thickness,
			 const BR_CColor& penColor,
			 const BR_CColor& fillColor,
			 unsigned short penPatternOrStyle,
			 // can't use PenStyle or BR_Pattern
			 BR_Boolean fromCtor);


	virtual void SetupTool(BR_CView& pane,
						   GraphicsToolSelectionOptions selectionOptions,
						   BR_SGraphicsToolSuspendResumeState* state);
	virtual void Unselect(BR_CView& pane,
						  GraphicsToolSelectionOptions selectionOptions,
						  BR_SGraphicsToolSuspendResumeState* state);

	BR_CPen(const BR_CBedDeferredTool& deferred);

private:
	PenThickness fThickness;
	BR_CBedPen* fBedPen;						// Non-NULL if this is a non-pattern pen
	BR_CBedWallPaper* fBedWallPaper;			// Non-NULL if this is a pattern pen
	BR_Boolean fInvisible;						// ?INTERNAL?

//----------------------------------------------------------------------------------------
// Macintosh
//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_MAC
public:
	void BedMacPrepareOp();
	static void BedMacPrepareNullOp();
#endif

	BR_SETCLASSNAME(BR_CPen);
};


//----------------------------------------------------------------------------------------
//	BR_CPen::IsInvisible
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CPen::IsInvisible() const
{
	return (fInvisible);
}

//----------------------------------------------------------------------------------------
//	BR_CPen::GetThickness
//----------------------------------------------------------------------------------------
inline BR_CPen::PenThickness BR_CPen::GetThickness() const
{
	return fThickness;
}

//----------------------------------------------------------------------------------------
//	BR_CView::IsPatternPen
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CPen::IsPatternPen() const
{
	return fBedWallPaper != NULL;
}

//----------------------------------------------------------------------------------------
//	BR_CView::BedGetWallPaper
//----------------------------------------------------------------------------------------
inline BR_CBedWallPaper* BR_CPen::BedGetWallPaper() const
{
	return fBedWallPaper;
}

//----------------------------------------------------------------------------------------
//	BR_CView::BedGetPen
//----------------------------------------------------------------------------------------
inline BR_CBedPen* BR_CPen::BedGetPen() const
{
	return fBedPen;
}

//========================================================================================
// CLASS BR_CDeferredPen
// Has the same functionality as BR_CPen only doesn't use system resources when not selected
//========================================================================================

class BR_CDeferredPen : public BR_CPen
{
public:
	BR_CDeferredPen(PenThickness penThickness,
				 const BR_CColor& penColor,
				 PenStyle penStyle);
				 
	virtual ~BR_CDeferredPen();

	BR_SETCLASSNAME(BR_CDeferredPen);
	
protected:
	virtual void OnAttributeChange();
	virtual void SetupTool(BR_CView& pane,	
						   GraphicsToolSelectionOptions selectionOptions,
						   BR_SGraphicsToolSuspendResumeState* state);
	virtual void Unselect(BR_CView& pane,	
						   GraphicsToolSelectionOptions selectionOptions,
						   BR_SGraphicsToolSuspendResumeState* state);
	
};

#endif
