#if !defined(BROPENFD_H) && !defined(__BEDRC__)
#define BROPENFD_H
//========================================================================================
//
//     File:			BROpenFD.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	3/13/92
//
//     COPYRIGHT 1992-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRDLGDIR_H  
#include "BRDlgDir.h"
#endif

#ifndef BCCOLL_H
#include "BCColl.h"
#endif

#ifndef BRTSTRS_H
#include "BRTStrs.h"
#endif

#if defined(BR_BUILD_MAC) && !defined(__STANDARDFILE__)
#include <StandardFile.h>
#endif

#if defined(BR_BUILD_MAC) && !defined(__FILES__)
#include <Files.h>
#endif

#if defined(BR_BUILD_WIN) && !defined(_INC_COMMDLG)
#include <commdlg.h>
#endif


//========================================================================================
// Forward class declarations
//========================================================================================
struct BR_SCallBack;
class BR_CFileSpecification;
class BR_CSFPDialogInfo;


//========================================================================================
//	BR_COpenFileDialog
//
//    Uses the Standard File Packages of Windows and Macintosh to
//  display a dialog box allowing the user to choose a file to open.  
//  The file name is returned in a file spec object.  The file spec 
//  is then used to open the file.
//========================================================================================

class BR_COpenFileDialog : public BR_CDialogDirector
{

public:
	BR_COpenFileDialog(BR_CBureaucrat* dialogSupervisor,
					   BR_CView* dialogEnclosure,
					   BR_CSFPDialogInfo* dialogInfo);

	BR_COpenFileDialog(BR_CBureaucrat* dialogSupervisor,
					   BR_CView* dialogEnclosure,
					   const BR_CModule& resourceModule,
					   BR_ResourceId resourceID,
					   BR_CSFPDialogInfo* dialogInfo);

	virtual ~BR_COpenFileDialog();

	virtual void ShowDialog();
	BR_CFileSpecification* GetFile() const;
	
	BR_CSFPDialogInfo* GetDialogInfo();
	void SetDialogInfo(BR_CSFPDialogInfo* newDialogInfo);
	

protected:
	BR_CSFPDialogInfo* fDialogInfo;
	BR_ResourceId	    fResourceID;


#ifdef BR_BUILD_MAC
protected:
	StandardFileReply*		fMacReply;
	
#endif

#ifdef BR_BUILD_WIN
protected:
	virtual void InitializeOPENFILENAME();
	virtual void CleanUpOPENFILENAME();

	LPOPENFILENAME		fWinReply;

#endif

	BR_SETCLASSNAME(BR_COpenFileDialog);
};



//========================================================================================
//	BR_CSaveFileDialog
//
//    Uses the Standard File Packages of Windows and Macintosh to 
//  display a dialog box requesting a file name from the user.  This
//  file name is then returned in a file spec object.  The file spec
//  is then used to save the current BR_CDocument object to disk.
//========================================================================================

class BR_CSaveFileDialog : public BR_COpenFileDialog
{
public:
	BR_CSaveFileDialog(BR_CBureaucrat* dialogSupervisor,
					   BR_CView* dialogEnclosure,
					   BR_CSFPDialogInfo* dialogInfo);

	BR_CSaveFileDialog(BR_CBureaucrat* dialogSupervisor,
					   BR_CView* dialogEnclosure,
					   const BR_CModule& resourceModule,
					   BR_ResourceId resourceID,
					   BR_CSFPDialogInfo* dialogInfo);
	
	virtual ~BR_CSaveFileDialog();

	virtual void ShowDialog();

	BR_SETCLASSNAME(BR_CSaveFileDialog);
};



#ifdef BR_BUILD_WIN
//========================================================================================
//	BR_CMultiFileDialog
//
//  Uses the Standard File Package of Windows to display a dialog box allowing the user to
//	choose a file(s) to open.  The file name(s) are returned in a 
//	BC_TCollection<BR_CFileSpec *> object.  The file spec list is then used
//  to open the file(s).
//
// WARNING: The BR_CMultiFileDialog has a KNOWN BUG!!  The total number of characters
//  in the names of the filenames plus the number of characters in the directory
//  name plus the spaces that go between them, should not exceed 255 characters.
//  This is merely the result of being unable to predict how many files the
//  user will select and being forced to pass in a fixed size buffer to the
//  Windows call.
//========================================================================================

class BR_CMultiFileDialog : public BR_COpenFileDialog
{
public:
	BR_CMultiFileDialog(BR_CBureaucrat* dialogSupervisor,
						BR_CView* Enclosure,
						BR_CSFPDialogInfo* dialogInfo);

	BR_CMultiFileDialog(BR_CBureaucrat* dialogSupervisor,
						BR_CView* dialogEnclosure,
						const BR_CModule& resourceModule,
						BR_ResourceId resourceID,
						BR_CSFPDialogInfo* dialogInfo);

	virtual ~BR_CMultiFileDialog();

	void GetListOfFiles(BC_TCollection<BR_CFileSpecification *> &listToFill);

private:
	virtual void InitializeOPENFILENAME();
	
	BR_SETCLASSNAME(BR_CMultiFileDialog);
};
#endif


//========================================================================================
//  CLASS BR_COpenFileDialog
//========================================================================================

inline BR_CSFPDialogInfo* BR_COpenFileDialog::GetDialogInfo()
{
	return(fDialogInfo);
}


#endif
