#if !defined(BROBJRES_H) && !defined(__BEDRC__)
#define BROBJRES_H
//========================================================================================
//
//     File:		BRObjRes.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	September 6, 1991
//
//     COPYRIGHT 1991-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRRESOUR_H
#include "BRResour.h"
#endif

#ifndef BCSTOREU_H
#include "BCStoreU.h"
#endif

#ifndef BCCOLLU_H
#include "BCCollU.h"
#endif


//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CBureaucrat;
class BR_CApplication;
class BR_CMenu;
class BR_CModule;
class BR_CView;

//========================================================================================
// Forward struct declarations
//========================================================================================

struct BR_SResource;
struct BR_SResourceHeader;

//========================================================================================
//	CLASS BR_CObjectResource
//========================================================================================

class BR_CObjectResource : public BR_CResource
{
public:
	BR_Char* GetClassName() const;
	BR_SResource* GetResource() const;
	const BR_CModule* GetModule() const;
	BR_CObject* GetParentObject() const;
	BR_Boolean CheckClass(BR_Char* className) const;
	BR_CObject* LoadObject();

protected:
	BR_CObjectResource(const BR_CModule* codeModule,
					   const BR_CModule* resourceModule,
					   BR_CObject* parentObject,
					   BR_ResourceId resourceId,
					   BR_ResourceType resourceType);

	virtual~ BR_CObjectResource();
	
	BR_Boolean AddObject(BR_CObject* object,
						 BR_ResourceId resourceId);

	BR_CObject* GetObject(BR_ResourceId resourceId) const;
	BR_SResourceHeader* GetResourceHeader() const;

	void SetResourceHeader(BR_SResourceHeader* resourceHeader);

private:
	const BR_CModule* fCodeModule;
		// Module for CreateObjectFromResource() method call.
	const BR_CModule* fResourceModule;
		// Module resource is contained in.
	BR_CObject* fParentObject;
		// Parent object: enclosure or supermenu.
	BC_TUnboundedCollection<BR_CObject *, BC_CUnmanaged> fObjectList;			
		// List of objects in the resource info.
	BR_SResourceHeader* fResourceHeader;
		// Resource header of current resource object.

	BR_SETCLASSNAME(BR_CObjectResource);
};

//----------------------------------------------------------------------------------------
//	BR_CObjectResource::GetResourceHeader
//----------------------------------------------------------------------------------------

inline BR_SResourceHeader* BR_CObjectResource::GetResourceHeader() const
{
	return fResourceHeader;
}

//----------------------------------------------------------------------------------------
//	BR_CObjectResource::SetResourceHeader
//----------------------------------------------------------------------------------------

inline void BR_CObjectResource::SetResourceHeader(BR_SResourceHeader* resourceHeader)
{
	fResourceHeader = resourceHeader;
}


//========================================================================================
//	CLASS BR_CViewResource
//========================================================================================

class BR_CViewResource : public BR_CObjectResource
{
public:
	BR_CViewResource(const BR_CModule* codeModule,
					 BR_CView* enclosure,
					 BR_CBureaucrat* supervisor,
					 const BR_CModule* resourceModule,
					 BR_ResourceId resourceId);
	virtual~ BR_CViewResource();

	BR_CView* GetEnclosure() const;
	BR_CBureaucrat* GetSupervisor() const;

private:
	BR_CBureaucrat* fSupervisor;	// Pointer to this resource's supervisor

	BR_SETCLASSNAME(BR_CViewResource);
};

//========================================================================================
//	CLASS BR_CMenuResource
//========================================================================================

class BR_CMenuResource : public BR_CObjectResource
{
public:
	BR_CMenuResource(const BR_CModule* codeModule,
					 BR_CApplication* application,
					 const BR_CModule* resourceModule,
					 BR_ResourceId resourceId);
	virtual~ BR_CMenuResource();

	BR_CApplication* GetApplication() const;
	BR_CMenu* GetParentMenu() const;

private:
	BR_CApplication* fApplication;
	
	BR_SETCLASSNAME(BR_CMenuResource);
};

#endif BROBJRES_H
