#if !defined(BRMPANOR_H) && !defined(__BEDRC__)
#define BRMPANOR_H
//========================================================================================
//
//     File:			BRMPanor.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	10/30/91
//
//     COPYRIGHT 1991-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BROBJECT_H
#include "BRObject.h"
#endif

//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CRectangle;


//========================================================================================
// CLASS BR_MMultiPanorama
//========================================================================================

class BR_MMultiPanorama : public BR_CObject
{
public:
	BR_MMultiPanorama(BR_MMultiPanorama* mySibling);
	virtual ~BR_MMultiPanorama();
	void AddSibling(BR_MMultiPanorama* mySibling);
	virtual void RefreshRect(BR_CRectangle& rectangle);
	virtual void Refresh(BR_Boolean erase);
	virtual void Update();
	virtual void AdjustInterior();

protected:
	typedef unsigned short int UpdateStyle;
	enum UpdateStyleConstants
	{
		kUpdateStyleRefreshRect = 1,
		kUpdateStyleRefresh = 2,
		kUpdateStyleUpdate = 4,
		kUpdateStyleAdjustInterior = 8
	};
	void ClearFlag(UpdateStyle updateStyle);
	void SetFlag(UpdateStyle updateStyle);
	BR_MMultiPanorama* SetSibling(BR_MMultiPanorama* mySibling);
	BR_MMultiPanorama* GetSibling() const;

private:
	BR_MMultiPanorama* fSibling;
	UpdateStyle fUpdateStyleFlags;

	BR_SETCLASSNAME(BR_MMultiPanorama);
};


//----------------------------------------------------------------------------------------
// BR_MMultiPanorama::ClearFlag
//----------------------------------------------------------------------------------------

inline void BR_MMultiPanorama::ClearFlag(UpdateStyle updateStyle)
{
	fUpdateStyleFlags &= (~updateStyle);
}

//----------------------------------------------------------------------------------------
// BR_MMultiPanorama::SetFlag
//----------------------------------------------------------------------------------------

inline void BR_MMultiPanorama::SetFlag(UpdateStyle updateStyle)
{
	fUpdateStyleFlags |= updateStyle;
}

//----------------------------------------------------------------------------------------
// BR_MMultiPanorama::SetSibling
//----------------------------------------------------------------------------------------

inline BR_MMultiPanorama* BR_MMultiPanorama::SetSibling(BR_MMultiPanorama* mySibling)
{
    BR_MMultiPanorama*  oldSibling = fSibling;

    fSibling = mySibling;
    return oldSibling;
}

//----------------------------------------------------------------------------------------
// BR_MMultiPanorama::GetSibling
//----------------------------------------------------------------------------------------

inline BR_MMultiPanorama* BR_MMultiPanorama::GetSibling() const
{
	return fSibling;
}

#endif
