#if !defined(BRMLGRES_H) && !defined(__BEDRC__)
#define BRMLGRES_H
//========================================================================================
//
//     File:			BRMLgRes.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	10/10/91
//
//     COPYRIGHT 1991-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   BRRESOUR_H
#include "BRResour.h"
#endif

//========================================================================================
// CLASS BR_CMultiLongRes
//========================================================================================

class BR_CMultiLongRes : public BR_CResource
{
public:
	BR_CMultiLongRes(const BR_CModule& resourceModule,
					 BR_ResourceId resourceId);
	virtual~ BR_CMultiLongRes();
	virtual BR_Boolean GetLong(long fKeyValue,
							   long& fDataValue) const;

	BR_SETCLASSNAME(BR_CMultiLongRes);
};

//========================================================================================
// STRUCT BR_SMultiLongResEntry
//
// The structure of an fEntryArray in an 'sMutiLongRes' resource.
//========================================================================================

struct BR_SMultiLongResEntry
{
	long fKeyValue;								// Key Value
	long fDataValue;							// Data Value
};

//========================================================================================
// STRUCT BR_SMultiLongRes
//
// The structure of a 'bclmultilong' type BRRCDefi resource.
//========================================================================================

struct BR_SMultiLongRes
{
	unsigned short fNumberOfEntries;			// Number of entries that follow
	BR_SMultiLongResEntry fEntryArray[1];		// Array of entries
};

#endif
