#if !defined(BRMDIDES_H) && !defined(__BEDRC__)
#define BRMDIDES_H
//========================================================================================
//
//     File:			BRMDIDes.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	May 19, 1992
//
//     COPYRIGHT 1992-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRAPPDES_H
#include "BRAppDes.h"  // always include the base class
#endif

#ifndef BRMENU_H
#include "BRMenu.h"  // always include the base class
#endif

//========================================================================================
//	class BR_CMDIAppDesktop
//========================================================================================

class BR_CMDIAppDesktop : public BR_CAppDesktop
{
public:
	BR_CMDIAppDesktop(BR_CApplication* supervisor);
	virtual~ BR_CMDIAppDesktop();

	virtual BR_Boolean DoCommand(CommandId commandId,
								 BR_CObject* notifier,
								 BR_Boolean callSupervisor = TRUE);
	virtual BR_CMenuBar* SetMenuBar(BR_CMenuBar* newMenuBar);
	BR_CWindowMenu* GetWindowMenu() const;
	virtual void UpdateMenus(BR_CMenuBar& menuBar,
							 BR_Boolean callSupervisor = TRUE);

private:
	BR_CWindowMenu* fWindowMenu;				// the Window menu

//-------------------------------------------------------------------------
//   Macintosh
//-------------------------------------------------------------------------
#ifdef BR_BUILD_MAC
public:
	virtual void TileWindows();
	virtual void CascadeWindows();

#endif

//-------------------------------------------------------------------------
//   Windows
//-------------------------------------------------------------------------
#ifdef BR_BUILD_WIN
public:
	virtual void SetFrame(const BR_CRectangle &newFrame,
								 BR_Boolean redraw);
	virtual BR_CWindow* GetActiveWindow() const;
	virtual BR_Boolean IsActiveWindowMaximized() const;
	virtual BR_Boolean IsInMenuBar(BR_PlatformMenuHandle menuHandle) const;
	virtual void UpdateSpecialMenu(BR_CPullDownMenu& menu);
	virtual void BedWinAdjustDesktopClientArea();

	// Focus-handling methods
	HWND GetClient() const;
	void SetClient(HWND hNewClient);
	LONG DoDefaultProc(WORD wMessage,
					   WORD wParam,
					   LONG lParam);
	virtual BR_Boolean IsValidMessage(HANDLE hAccel,
									  MSG& msg);
	virtual HWND GetRealHandle() const;

private:
	HWND fClient;								// the MDI client window

#endif

	BR_SETCLASSNAME(BR_CMDIAppDesktop);
};

#ifdef SkipForNow
//----------------------------------------------------------------------------------------
//	BR_CMDIAppDesktop::GetWindowMenu
//----------------------------------------------------------------------------------------
inline BR_CWindowMenu* BR_CMDIAppDesktop::GetWindowMenu() const
{
	return fWindowMenu;
}

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
//	BR_CMDIAppDesktop::GetClient
//----------------------------------------------------------------------------------------
inline HWND BR_CMDIAppDesktop::GetClient() const
{
	return fClient;
}
#endif

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
//	BR_CMDIAppDesktop::SetClient
//----------------------------------------------------------------------------------------
inline void BR_CMDIAppDesktop::SetClient(HWND hNewClient)
{
	fClient = hNewClient;
}
#endif

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
//	BR_CMDIAppDesktop::GetRealHandle
//----------------------------------------------------------------------------------------
inline HWND BR_CMDIAppDesktop::GetRealHandle() const
{ 
	return GetClient();
}
#endif
#endif

#endif


